/*
 * Decompiled with CFR 0.152.
 */
package org.micromanager.remote;

import java.nio.ByteBuffer;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingDeque;
import mmcorej.org.json.JSONException;
import mmcorej.org.json.JSONObject;
import org.micromanager.internal.zmq.ZMQPushSocket;
import org.micromanager.ndtiffstorage.ImageWrittenListener;
import org.micromanager.ndtiffstorage.IndexEntryData;
import org.micromanager.ndtiffstorage.NDTiffStorage;
import org.micromanager.remote.RemoteAcquisition;

public class RemoteStorageMonitor
implements ImageWrittenListener {
    private ZMQPushSocket<IndexEntryData> pushSocket_;
    private RemoteAcquisition acq_;
    private ExecutorService executor_ = Executors.newSingleThreadExecutor(r -> new Thread(r, "Remote Event Source thread"));
    private LinkedBlockingDeque<IndexEntryData> indexEntries_ = new LinkedBlockingDeque();
    private final String diskLocation_;
    private final JSONObject summaryMetadata_;

    public RemoteStorageMonitor(NDTiffStorage storage) {
        this.diskLocation_ = storage.getDiskLocation();
        this.summaryMetadata_ = storage.getSummaryMetadata();
        this.pushSocket_ = new ZMQPushSocket<IndexEntryData>(t -> {
            try {
                JSONObject message = new JSONObject();
                if (t.isDataSetFinishedEntry()) {
                    message.put("finished", true);
                } else {
                    message.put("index_entry", (Object)((ByteBuffer)t.asByteBuffer()).array());
                }
                return message;
            }
            catch (JSONException e) {
                throw new RuntimeException("Problem with data saved socket");
            }
        });
    }

    public JSONObject getSummaryMetadata() {
        return this.summaryMetadata_;
    }

    public String getDiskLocation() {
        return this.diskLocation_;
    }

    public void start() {
        this.executor_.submit(() -> {
            try {
                boolean finished;
                do {
                    finished = false;
                    if (this.indexEntries_.size() > 0) {
                        IndexEntryData e = this.indexEntries_.takeFirst();
                        if (e.dataSetFinishedEntry_) {
                            finished = true;
                            continue;
                        }
                        this.pushSocket_.push(e);
                        continue;
                    }
                    if (this.executor_.isShutdown()) {
                        finished = true;
                        continue;
                    }
                    Thread.sleep(1L);
                } while (!finished);
                this.pushSocket_.push(IndexEntryData.createFinishedEntry());
                this.executor_.shutdown();
                this.pushSocket_.close();
                return;
            }
            catch (Exception e) {
                if (this.executor_.isShutdown()) {
                    return;
                }
                e.printStackTrace();
                throw new RuntimeException(e);
            }
        });
    }

    public int getPort() {
        return this.pushSocket_.getPort();
    }

    public void imageWritten(IndexEntryData ied) {
        this.indexEntries_.addLast(ied);
    }

    public void awaitCompletion() {
        while (!this.executor_.isTerminated()) {
            try {
                Thread.sleep(5L);
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

