/*
 * Decompiled with CFR 0.152.
 */
package org.micromanager.explore;

import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Stream;
import mmcorej.org.json.JSONObject;
import org.micromanager.acqj.api.AcqEngJDataSink;
import org.micromanager.acqj.api.AcquisitionAPI;
import org.micromanager.acqj.api.AcquisitionHook;
import org.micromanager.acqj.internal.Engine;
import org.micromanager.acqj.internal.ZAxis;
import org.micromanager.acqj.main.AcqEngMetadata;
import org.micromanager.acqj.main.AcquisitionEvent;
import org.micromanager.acqj.main.XYTiledAcquisition;
import org.micromanager.acqj.util.AcqEventModules;
import org.micromanager.acqj.util.AcquisitionEventIterator;
import org.micromanager.acqj.util.ChannelSetting;
import org.micromanager.acqj.util.xytiling.XYStagePosition;
import org.micromanager.explore.ChannelGroupSettings;
import org.micromanager.explore.ExploreAcqUIAndStorage;
import org.micromanager.ndtiffstorage.NDTiffAPI;
import org.micromanager.ndviewer.api.NDViewerAcqInterface;
import org.micromanager.remote.PycroManagerCompatibleAcq;

public class ExploreAcquisition
extends XYTiledAcquisition
implements PycroManagerCompatibleAcq,
NDViewerAcqInterface {
    private List<XYStagePosition> positions_;
    private Set<HashMap<String, Object>> queuedTileEvents_ = new CopyOnWriteArraySet<HashMap<String, Object>>();
    private ExecutorService submittedSequenceMonitorExecutor_ = Executors.newSingleThreadExecutor(r -> new Thread(r, "Submitted sequence monitor"));
    private Consumer<String> logger_;
    ChannelGroupSettings channels_;

    public ExploreAcquisition(int pixelOverlapX, int pixelOverlapY, double zStep, ChannelGroupSettings channels, ExploreAcqUIAndStorage adapter) throws Exception {
        this(pixelOverlapX, pixelOverlapY, zStep, channels, adapter, s -> {});
    }

    public ExploreAcquisition(int pixelOverlapX, int pixelOverlapY, final double zStep, ChannelGroupSettings channels, AcqEngJDataSink adapter, Consumer<String> logger) throws Exception {
        super(adapter, Integer.valueOf(pixelOverlapX), Integer.valueOf(pixelOverlapY), Double.valueOf(zStep), (Consumer)new Consumer<JSONObject>(){

            @Override
            public void accept(JSONObject summaryMetadata) {
                AcqEngMetadata.setExploreAcq((JSONObject)summaryMetadata, (boolean)true);
                AcqEngMetadata.setZStepUm((JSONObject)summaryMetadata, (double)zStep);
            }
        });
        this.logger_ = logger;
        this.channels_ = channels;
        this.createXYPositions();
        this.addHook(new AcquisitionHook(){

            public AcquisitionEvent run(AcquisitionEvent event) {
                if (ExploreAcquisition.this.queuedTileEvents_.contains(event.getAxisPositions())) {
                    ExploreAcquisition.this.queuedTileEvents_.remove(event.getAxisPositions());
                }
                return event;
            }

            public void close() {
            }
        }, 1);
    }

    public double getZOrigin(String name) {
        return ((ZAxis)this.getZAxes().get((Object)name)).zOrigin_um_;
    }

    public double getZStep(String name) {
        return ((ZAxis)this.getZAxes().get((Object)name)).zStep_um_;
    }

    public boolean isFinished() {
        return this.areEventsFinished() && this.getDataSink().isFinished();
    }

    public void abort() {
        super.abort();
        this.submittedSequenceMonitorExecutor_.shutdownNow();
    }

    public Future submitEventIterator(Iterator<AcquisitionEvent> iter) {
        return this.submittedSequenceMonitorExecutor_.submit(() -> {
            Future iteratorFuture = null;
            try {
                iteratorFuture = super.submitEventIterator(iter);
                iteratorFuture.get();
            }
            catch (InterruptedException ex) {
                iteratorFuture.cancel(true);
            }
            catch (ExecutionException ex) {
                ex.printStackTrace();
                this.logger_.accept(ex.getMessage());
            }
        });
    }

    private void createXYPositions() {
        try {
            this.positions_ = new ArrayList<XYStagePosition>();
            this.positions_.add(new XYStagePosition(new Point2D.Double(Engine.getCore().getXPosition(), Engine.getCore().getYPosition()), 0, 0));
        }
        catch (Exception e) {
            e.printStackTrace();
            this.logger_.accept("Problem with Acquisition's XY positions. Check acquisition settings");
            throw new RuntimeException();
        }
    }

    public LinkedBlockingQueue<HashMap<String, Object>> getTilesWaitingToAcquireAtSlice(HashMap<String, Integer> zAxisPositions) {
        if (this.queuedTileEvents_ == null) {
            return null;
        }
        LinkedBlockingQueue<HashMap<String, Object>> tiles = new LinkedBlockingQueue<HashMap<String, Object>>();
        for (HashMap<String, Object> axes : this.queuedTileEvents_) {
            boolean match = true;
            for (String zName : zAxisPositions.keySet()) {
                if (axes.get(zName).equals(zAxisPositions.get(zName))) continue;
                match = false;
                break;
            }
            if (!match) continue;
            tiles.add(axes);
        }
        return tiles;
    }

    public void acquireTileAtCurrentLocation() throws Exception {
        double yPos;
        double xPos;
        try {
            xPos = Engine.getCore().getXPosition();
            yPos = Engine.getCore().getYPosition();
        }
        catch (Exception ex) {
            this.logger_.accept("Couldnt get device positions from core");
            return;
        }
        HashMap<String, Integer> zTopIndex = new HashMap<String, Integer>();
        HashMap<String, Integer> zBottomIndex = new HashMap<String, Integer>();
        for (String zName : this.getZDeviceNames()) {
            double zPosition = Engine.getCore().getPosition(zName);
            int zIndex = (int)Math.round((zPosition - this.getZOrigin(zName)) / this.getZStep(zName));
            zTopIndex.put(zName, zIndex);
            zBottomIndex.put(zName, zIndex);
        }
        int posIndex = this.pixelStageTranslator_.getFullResPositionIndexFromStageCoords(xPos, yPos);
        this.submitEvents(new int[]{this.pixelStageTranslator_.getXYPosition(posIndex).getGridRow()}, new int[]{this.pixelStageTranslator_.getXYPosition(posIndex).getGridCol()}, zTopIndex, zBottomIndex);
    }

    public void acquireTiles(int r1, int c1, int r2, int c2) {
        new Thread(() -> {
            HashMap<String, Integer> zMinIndices = new HashMap<String, Integer>();
            HashMap<String, Integer> zMaxIndices = new HashMap<String, Integer>();
            for (String zName : this.getZDeviceNames()) {
                try {
                    zMinIndices.put(zName, this.getZLimitLowerSliceIndex(zName));
                    zMaxIndices.put(zName, this.getZLimitUpperSliceIndex(zName));
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
            int row1 = Math.min(r1, r2);
            int row2 = Math.max(r1, r2);
            int col1 = Math.min(c1, c2);
            int col2 = Math.max(c1, c2);
            int[] newPositionRows = new int[(row2 - row1 + 1) * (col2 - col1 + 1)];
            int[] newPositionCols = new int[(row2 - row1 + 1) * (col2 - col1 + 1)];
            for (int r = row1; r <= row2; ++r) {
                int c = col1;
                while (c <= col2) {
                    int relativeRow = r - row1;
                    int relativeCol = c - col1;
                    int numRows = 1 + row2 - row1;
                    int i = (relativeCol % 2 == 0 ? relativeRow : numRows - relativeRow - 1) + numRows * relativeCol;
                    newPositionRows[i] = r;
                    newPositionCols[i] = c++;
                }
            }
            this.submitEvents(newPositionRows, newPositionCols, zMinIndices, zMaxIndices);
        }).start();
    }

    private void submitEvents(int[] newPositionRows, int[] newPositionCols, HashMap<String, Integer> zMinIndices, HashMap<String, Integer> zMaxIndices) {
        int[] posIndices = this.getPixelStageTranslator().getPositionIndices(newPositionRows, newPositionCols);
        List allPositions = this.getPixelStageTranslator().getPositionList();
        ArrayList<XYStagePosition> selectedXYPositions = new ArrayList<XYStagePosition>();
        for (int i : posIndices) {
            selectedXYPositions.add((XYStagePosition)allPositions.get(i));
        }
        ArrayList<Function> acqFunctions = new ArrayList<Function>();
        acqFunctions.add(this.positions(selectedXYPositions));
        for (String zName : this.getZDeviceNames()) {
            acqFunctions.add(AcqEventModules.moveStage((String)zName, (int)zMinIndices.get(zName), (int)(zMaxIndices.get(zName) + 1), (double)this.getZStep(zName), (double)this.getZOrigin(zName)));
        }
        if (this.channels_ != null && this.channels_.getNumChannels() > 0) {
            ArrayList<ChannelSetting> channels = new ArrayList<ChannelSetting>();
            for (String name : this.channels_.getChannelNames()) {
                if (!this.channels_.getChannelSetting((String)name).use_) continue;
                channels.add(this.channels_.getChannelSetting(name));
            }
            acqFunctions.add(AcqEventModules.channels(channels));
        }
        AcquisitionEvent baseEvent = new AcquisitionEvent((AcquisitionAPI)this);
        AcquisitionEventIterator iterator = new AcquisitionEventIterator(baseEvent, acqFunctions, this.monitorSliceIndices());
        Predicate<AcquisitionEvent> predicate = this.filterExistingEventsAndDisplayQueuedTiles();
        LinkedList<AcquisitionEvent> eventList = new LinkedList<AcquisitionEvent>();
        while (iterator.hasNext()) {
            AcquisitionEvent event = (AcquisitionEvent)iterator.next();
            if (!predicate.test(event)) continue;
            eventList.add(event);
        }
        ArrayList<Function<AcquisitionEvent, Iterator>> list = new ArrayList<Function<AcquisitionEvent, Iterator>>();
        Function<AcquisitionEvent, Iterator> fn = t -> eventList.iterator();
        list.add(fn);
        AcquisitionEvent event = new AcquisitionEvent((AcquisitionAPI)this);
        this.submitEventIterator((Iterator<AcquisitionEvent>)new AcquisitionEventIterator(event, list));
    }

    private Function<AcquisitionEvent, Iterator<AcquisitionEvent>> positions(List<XYStagePosition> positions) {
        return event -> {
            Stream.Builder<AcquisitionEvent> builder = Stream.builder();
            if (positions == null) {
                builder.accept((AcquisitionEvent)event);
            } else {
                for (int index = 0; index < positions.size(); ++index) {
                    AcquisitionEvent posEvent = event.copy();
                    posEvent.setAxisPosition("row", (Object)((XYStagePosition)positions.get(index)).getGridRow());
                    posEvent.setAxisPosition("column", (Object)((XYStagePosition)positions.get(index)).getGridCol());
                    posEvent.setX(((XYStagePosition)positions.get((int)index)).getCenter().x);
                    posEvent.setY(((XYStagePosition)positions.get((int)index)).getCenter().y);
                    builder.accept(posEvent);
                }
            }
            return builder.build().iterator();
        };
    }

    private Predicate<AcquisitionEvent> filterExistingEventsAndDisplayQueuedTiles() {
        return event -> {
            if (this.queuedTileEvents_.contains(event.getAxisPositions())) {
                return false;
            }
            this.queuedTileEvents_.add(event.getAxisPositions());
            return true;
        };
    }

    private Function<AcquisitionEvent, AcquisitionEvent> monitorSliceIndices() {
        return event -> {
            try {
                for (String name : this.getZDeviceNames()) {
                    ((ZAxis)this.getZAxes().get((Object)name)).lowestExploredZIndex_ = Math.min(((ZAxis)this.getZAxes().get((Object)name)).lowestExploredZIndex_, this.getZLimitLowerSliceIndex(name));
                    ((ZAxis)this.getZAxes().get((Object)name)).highestExploredZIndex_ = Math.max(((ZAxis)this.getZAxes().get((Object)name)).highestExploredZIndex_, this.getZLimitUpperSliceIndex(name));
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return event;
        };
    }

    private int getZLimitLowerSliceIndex(String name) {
        return ((ZAxis)this.getZAxes().get((Object)name)).exploreLowerZIndexLimit_;
    }

    private int getZLimitUpperSliceIndex(String name) {
        return ((ZAxis)this.getZAxes().get((Object)name)).exploreUpperZIndexLimit_;
    }

    public void setZLimits(String name, double zTop, double zBottom) {
        ((ZAxis)this.getZAxes().get((Object)name)).exploreLowerZIndexLimit_ = (int)((Math.min(zTop, zBottom) - this.getZOrigin(name)) / ((ZAxis)this.getZAxes().get((Object)name)).zStep_um_);
        ((ZAxis)this.getZAxes().get((Object)name)).exploreUpperZIndexLimit_ = (int)((Math.max(zTop, zBottom) - this.getZOrigin(name)) / ((ZAxis)this.getZAxes().get((Object)name)).zStep_um_);
    }

    @Override
    public NDTiffAPI getStorage() {
        return ((ExploreAcqUIAndStorage)this.dataSink_).getStorage();
    }

    @Override
    public int getEventPort() {
        return -1;
    }
}

