/*
 * Decompiled with CFR 0.152.
 */
package org.micromanager.explore.gui;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Rectangle;
import javax.swing.JComponent;
import javax.swing.JScrollBar;
import javax.swing.plaf.basic.BasicScrollBarUI;

public class ColorableScrollbarUI
extends BasicScrollBarUI {
    private static final Color DARK_GREEN = new Color(0, 70, 0);
    private volatile int displayedSliceIndex_;
    private volatile int minSliceIndex_;
    private volatile int maxSliceIndex_;
    private String name_;

    public ColorableScrollbarUI(String name) {
        this.name_ = name;
    }

    public void setHighlightedIndices(int currentIndex, int min, int max) {
        this.displayedSliceIndex_ = currentIndex;
        this.minSliceIndex_ = min;
        this.maxSliceIndex_ = max;
    }

    @Override
    protected void paintThumb(Graphics g, JComponent c, Rectangle thumbBounds) {
        super.paintThumb(g, c, thumbBounds);
        if (((JScrollBar)c).getValue() == this.displayedSliceIndex_) {
            g.setColor(DARK_GREEN);
            g.drawRect(thumbBounds.x, thumbBounds.y, thumbBounds.width, thumbBounds.height);
        }
    }

    @Override
    protected void paintTrack(Graphics g, JComponent c, Rectangle trackBounds) {
        super.paintTrack(g, c, trackBounds);
        int numPositions = ((JScrollBar)c).getMaximum() - ((JScrollBar)c).getMinimum();
        g.setColor(new Color(180, 220, 180));
        int rangeStart = (int)((double)(this.minSliceIndex_ - ((JScrollBar)c).getMinimum()) / (double)numPositions * (double)trackBounds.width) + trackBounds.x;
        int rangeWidth = (int)((double)(this.maxSliceIndex_ - this.minSliceIndex_ + 1) / (double)numPositions * (double)trackBounds.width);
        g.fillRect(rangeStart, trackBounds.y, rangeWidth, trackBounds.height);
        g.setColor(DARK_GREEN);
        int start = (int)((double)(this.displayedSliceIndex_ - ((JScrollBar)c).getMinimum()) / (double)numPositions * (double)trackBounds.width) + trackBounds.x;
        int width = (int)(1.0 / (double)numPositions * (double)trackBounds.width);
        g.fillRect(start, trackBounds.y, width, trackBounds.height);
    }
}

