/*
 * Decompiled with CFR 0.152.
 */
package org.micromanager.explore.gui;

import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.util.function.Consumer;
import javax.swing.SwingUtilities;
import org.micromanager.acqj.main.XYTiledAcquisition;
import org.micromanager.acqj.util.xytiling.CameraTilingStageTranslator;
import org.micromanager.explore.ExploreAcquisition;
import org.micromanager.explore.gui.ExploreMouseListenerAPI;
import org.micromanager.ndviewer.api.CanvasMouseListenerInterface;
import org.micromanager.ndviewer.main.NDViewer;

public class ExploreMouseListener
implements CanvasMouseListenerInterface,
ExploreMouseListenerAPI {
    protected static final int MOUSE_WHEEL_ZOOM_INTERVAL_MS = 100;
    protected static final double ZOOM_FACTOR_MOUSE = 1.4;
    protected volatile Point mouseDragStartPointLeft_;
    protected volatile Point mouseDragStartPointRight_;
    protected volatile Point currentMouseLocation_;
    protected volatile long lastMouseWheelZoomTime_ = 0L;
    protected XYTiledAcquisition acq_;
    protected NDViewer viewer_;
    protected volatile Point exploreStartTile_;
    protected volatile Point exploreEndTile_;
    protected Consumer<String> logger_;
    private CameraTilingStageTranslator pixelStageTranslator_;

    public ExploreMouseListener(XYTiledAcquisition acquisition, NDViewer viewer, Consumer<String> logger) {
        this.acq_ = acquisition;
        this.viewer_ = viewer;
        this.logger_ = logger;
        this.pixelStageTranslator_ = this.acq_.getPixelStageTranslator();
    }

    public void mouseWheelMoved(MouseWheelEvent mwe) {
        long currentTime = System.currentTimeMillis();
        if (currentTime - this.lastMouseWheelZoomTime_ > 100L) {
            this.lastMouseWheelZoomTime_ = currentTime;
            this.mouseWheelMovedActions(mwe);
        }
    }

    public void mouseMoved(MouseEvent e) {
        this.currentMouseLocation_ = e.getPoint();
        this.mouseMovedActions(e);
    }

    public void mousePressed(MouseEvent e) {
        this.viewer_.getCanvasJPanel().requestFocusInWindow();
        if (SwingUtilities.isRightMouseButton(e)) {
            this.mouseDragStartPointRight_ = e.getPoint();
        } else if (SwingUtilities.isLeftMouseButton(e)) {
            this.mouseDragStartPointLeft_ = e.getPoint();
        }
        this.mousePressedActions(e);
    }

    public void mouseReleased(MouseEvent e) {
        this.mouseReleasedActions(e);
        this.mouseDragStartPointLeft_ = null;
        this.mouseDragStartPointRight_ = null;
        this.viewer_.redrawOverlay();
    }

    public void mouseEntered(MouseEvent e) {
        this.mouseEnteredActions(e);
    }

    public void mouseExited(MouseEvent e) {
        this.currentMouseLocation_ = null;
        this.mouseExitedActions(e);
    }

    public void mouseDragged(MouseEvent e) {
        this.currentMouseLocation_ = e.getPoint();
        this.mouseDraggedActions(e);
    }

    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public Point getExploreStartTile() {
        return this.exploreStartTile_;
    }

    @Override
    public Point getExploreEndTile() {
        return this.exploreEndTile_;
    }

    @Override
    public Point getMouseDragStartPointLeft() {
        return this.mouseDragStartPointLeft_;
    }

    @Override
    public Point getCurrentMouseLocation() {
        return this.currentMouseLocation_;
    }

    protected void acquireTiles() {
        ((ExploreAcquisition)this.acq_).acquireTiles(this.exploreStartTile_.y, this.exploreStartTile_.x, this.exploreEndTile_.y, this.exploreEndTile_.x);
        this.exploreStartTile_ = null;
        this.exploreEndTile_ = null;
    }

    protected void recordTilesForConfirmation(Point p2) {
        this.exploreStartTile_ = this.pixelStageTranslator_.getTileIndicesFromDisplayedPixel(this.viewer_.getMagnification(), this.mouseDragStartPointLeft_.x, this.mouseDragStartPointLeft_.y, this.viewer_.getViewOffset().x, this.viewer_.getViewOffset().y);
        this.exploreEndTile_ = this.pixelStageTranslator_.getTileIndicesFromDisplayedPixel(this.viewer_.getMagnification(), p2.x, p2.y, this.viewer_.getViewOffset().x, this.viewer_.getViewOffset().y);
    }

    protected void mouseReleasedActions(MouseEvent e) {
        if (SwingUtilities.isLeftMouseButton(e)) {
            Point p2 = e.getPoint();
            if (this.exploreStartTile_ != null) {
                this.acquireTiles();
            } else {
                this.recordTilesForConfirmation(p2);
            }
            this.viewer_.redrawOverlay();
        }
        this.viewer_.redrawOverlay();
    }

    protected void mousePressedActions(MouseEvent e) {
        if (SwingUtilities.isRightMouseButton(e)) {
            this.exploreEndTile_ = null;
            this.exploreStartTile_ = null;
        }
        this.viewer_.redrawOverlay();
    }

    protected void mouseExitedActions(MouseEvent e) {
        this.viewer_.redrawOverlay();
    }

    protected void mouseEnteredActions(MouseEvent e) {
        this.viewer_.redrawOverlay();
    }

    protected void mouseDraggedActions(MouseEvent e) {
        Point currentPoint = e.getPoint();
        if (SwingUtilities.isRightMouseButton(e)) {
            this.viewer_.pan(this.mouseDragStartPointRight_.x - currentPoint.x, this.mouseDragStartPointRight_.y - currentPoint.y);
            this.mouseDragStartPointRight_ = currentPoint;
        }
        this.viewer_.redrawOverlay();
    }

    protected void mouseWheelMovedActions(MouseWheelEvent mwe) {
        if (mwe.getWheelRotation() < 0) {
            this.viewer_.zoom(0.7142857142857143, this.currentMouseLocation_);
        } else if (mwe.getWheelRotation() > 0) {
            this.viewer_.zoom(1.4, this.currentMouseLocation_);
        }
        this.viewer_.redrawOverlay();
    }

    protected void mouseMovedActions(MouseEvent e) {
        this.viewer_.redrawOverlay();
    }
}

