/*
 * Decompiled with CFR 0.152.
 */
package org.micromanager.explore.gui;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.geom.Point2D;
import java.util.HashMap;
import java.util.concurrent.LinkedBlockingQueue;
import org.micromanager.acqj.main.XYTiledAcquisition;
import org.micromanager.acqj.util.xytiling.CameraTilingStageTranslator;
import org.micromanager.explore.ExploreAcquisition;
import org.micromanager.explore.gui.ExploreMouseListenerAPI;
import org.micromanager.ndviewer.api.NDViewerAPI;
import org.micromanager.ndviewer.api.OverlayerPlugin;
import org.micromanager.ndviewer.overlay.Overlay;
import org.micromanager.ndviewer.overlay.Roi;
import org.micromanager.ndviewer.overlay.TextRoi;

public class ExploreOverlayer
implements OverlayerPlugin {
    private static final Color LIGHT_BLUE = new Color(200, 200, 255);
    private static final Color TRANSPARENT_BLUE = new Color(0, 0, 255, 100);
    private static final Color TRANSPARENT_GREEN = new Color(0, 255, 0, 100);
    private static final Color TRANSPARENT_MAGENTA = new Color(255, 0, 255, 100);
    private ExploreMouseListenerAPI mouseListener_;
    private boolean active_ = true;
    private CameraTilingStageTranslator pixelStageTranslator_;
    private NDViewerAPI viewer_;
    private XYTiledAcquisition acq_;

    public ExploreOverlayer(NDViewerAPI viewer, ExploreMouseListenerAPI mouseListener, XYTiledAcquisition acq) {
        this.mouseListener_ = mouseListener;
        this.pixelStageTranslator_ = acq.getPixelStageTranslator();
        this.viewer_ = viewer;
        this.acq_ = acq;
    }

    public void setActive(boolean b) {
        this.active_ = b;
    }

    public void drawOverlay(Overlay defaultOverlay, Point2D.Double displayImageSize, double downsampleFactor, Graphics g, HashMap<String, Object> axes, double magnification, Point2D.Double viewOffset) throws InterruptedException {
        if (this.active_) {
            Overlay easyOverlay = new Overlay();
            this.addExploreToOverlay(easyOverlay, magnification, g, displayImageSize);
            this.viewer_.setOverlay(easyOverlay);
        }
    }

    public void addExploreToOverlay(Overlay overlay, double magnification, Graphics g, Point2D.Double displayImageSize) {
        Point currentMouseLocation = this.mouseListener_.getCurrentMouseLocation();
        if (this.mouseListener_.getExploreEndTile() != null) {
            this.highlightTilesOnOverlay(overlay, Math.min(this.mouseListener_.getExploreEndTile().y, this.mouseListener_.getExploreStartTile().y), Math.max(this.mouseListener_.getExploreEndTile().y, this.mouseListener_.getExploreStartTile().y), Math.min(this.mouseListener_.getExploreEndTile().x, this.mouseListener_.getExploreStartTile().x), Math.max(this.mouseListener_.getExploreEndTile().x, this.mouseListener_.getExploreStartTile().x), TRANSPARENT_MAGENTA, magnification);
            this.addTextBox(new String[]{"Left click again to confirm acquire", "Right click to cancel"}, overlay, g, displayImageSize);
        } else if (this.mouseListener_.getMouseDragStartPointLeft() != null) {
            Point dragStart = this.mouseListener_.getMouseDragStartPointLeft();
            Point p2Tiles = this.pixelStageTranslator_.getTileIndicesFromDisplayedPixel(this.viewer_.getMagnification(), currentMouseLocation.x, currentMouseLocation.y, this.viewer_.getViewOffset().x, this.viewer_.getViewOffset().y);
            Point p1Tiles = this.pixelStageTranslator_.getTileIndicesFromDisplayedPixel(this.viewer_.getMagnification(), dragStart.x, dragStart.y, this.viewer_.getViewOffset().x, this.viewer_.getViewOffset().y);
            this.highlightTilesOnOverlay(overlay, Math.min(p1Tiles.y, p2Tiles.y), Math.max(p1Tiles.y, p2Tiles.y), Math.min(p1Tiles.x, p2Tiles.x), Math.max(p1Tiles.x, p2Tiles.x), TRANSPARENT_BLUE, magnification);
        } else if (currentMouseLocation != null) {
            Point coords = this.pixelStageTranslator_.getTileIndicesFromDisplayedPixel(this.viewer_.getMagnification(), currentMouseLocation.x, currentMouseLocation.y, this.viewer_.getViewOffset().x, this.viewer_.getViewOffset().y);
            this.highlightTilesOnOverlay(overlay, coords.y, coords.y, coords.x, coords.x, TRANSPARENT_BLUE, magnification);
        } else if (!this.acq_.anythingAcquired()) {
            String[] text = new String[]{"Explore mode controls:", "", "Left click or left click and drag to select tiles", "Left click again to confirm", "Right click and drag to pan", "+/- keys or mouse wheel to zoom in/out"};
            this.addTextBox(text, overlay, g, displayImageSize);
        }
        LinkedBlockingQueue<HashMap<String, Object>> tiles = this.getTilesWaitingToAcquireAtVisibleSlice();
        if (tiles != null) {
            for (HashMap<String, Object> t : tiles) {
                try {
                    this.highlightTilesOnOverlay(overlay, ((Integer)t.get("row")).intValue(), ((Integer)t.get("row")).intValue(), ((Integer)t.get("column")).intValue(), ((Integer)t.get("column")).intValue(), TRANSPARENT_GREEN, magnification);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    private LinkedBlockingQueue<HashMap<String, Object>> getTilesWaitingToAcquireAtVisibleSlice() {
        HashMap<String, Integer> zAxisPositions = new HashMap<String, Integer>();
        for (String zAxisName : this.acq_.getZAxes().keySet()) {
            zAxisPositions.put(zAxisName, (Integer)this.viewer_.getAxisPosition(zAxisName));
        }
        return ((ExploreAcquisition)this.acq_).getTilesWaitingToAcquireAtSlice(zAxisPositions);
    }

    private void addTextBox(String[] text, Overlay overlay, Graphics g, Point2D.Double displayImageSize) {
        int fontSize = 12;
        Font font = new Font("Arial", 1, fontSize);
        float lineHeight = 0.0f;
        float textWidth = 0.0f;
        for (String line : text) {
            lineHeight = Math.max(lineHeight, g.getFontMetrics(font).getLineMetrics(line, g).getHeight());
            textWidth = Math.max(textWidth, (float)g.getFontMetrics().stringWidth(line));
        }
        float textHeight = lineHeight * (float)text.length;
        int border = 10;
        int roiWidth = (int)((double)(textWidth + (float)(2 * border)) * 1.3);
        int roiHeight = (int)(textHeight + (float)(2 * border));
        Roi rectangle = new Roi(displayImageSize.x / 2.0 - (double)(roiWidth / 2), displayImageSize.y / 2.0 - (double)(roiHeight / 2), (double)roiWidth, (double)roiHeight);
        rectangle.setStrokeWidth(3.0f);
        rectangle.setFillColor(LIGHT_BLUE);
        overlay.add(rectangle);
        for (int i = 0; i < text.length; ++i) {
            TextRoi troi = new TextRoi(displayImageSize.x / 2.0 - (double)(roiWidth / 2) + (double)border, displayImageSize.y / 2.0 - (double)(roiHeight / 2) + (double)border + (double)(lineHeight * (float)i), text[i], font);
            troi.setStrokeColor(Color.black);
            overlay.add((Roi)troi);
        }
    }

    private void highlightTilesOnOverlay(Overlay base, long row1, long row2, long col1, long col2, Color color, double magnification) {
        Point topLeft = this.pixelStageTranslator_.getDisplayedPixel(this.viewer_.getMagnification(), row1, col1, this.viewer_.getViewOffset().x, this.viewer_.getViewOffset().y);
        int width = (int)Math.round((double)((long)this.pixelStageTranslator_.getDisplayTileWidth() * (col2 - col1 + 1L)) * magnification);
        int height = (int)Math.round((double)((long)this.pixelStageTranslator_.getDisplayTileHeight() * (row2 - row1 + 1L)) * magnification);
        Roi rect = new Roi(topLeft.x, topLeft.y, width, height);
        rect.setFillColor(color);
        base.add(rect);
    }
}

