/*
 * Decompiled with CFR 0.152.
 */
package org.micromanager.explore.gui;

import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.AbstractTableModel;
import mmcorej.CMMCore;
import org.micromanager.acqj.internal.Engine;
import org.micromanager.explore.ChannelGroupSettings;

public class SimpleChannelTableModel
extends AbstractTableModel
implements TableModelListener {
    private ChannelGroupSettings channels_;
    private final CMMCore core_ = Engine.getCore();
    private boolean selectAll_ = true;
    public static final String[] COLUMN_NAMES = new String[]{"Use", "Configuration", "Exposure", "Z-offset (um)"};

    public SimpleChannelTableModel(ChannelGroupSettings channels) {
        this.channels_ = channels;
    }

    public void selectAllChannels() {
        this.channels_.setUseOnAll(this.selectAll_);
        this.selectAll_ = !this.selectAll_;
        this.fireTableDataChanged();
    }

    public void synchronizeExposures() {
        this.channels_.synchronizeExposures();
        this.fireTableDataChanged();
    }

    public void setChannelGroup(String group) {
        if (this.channels_ != null) {
            this.channels_.updateChannelGroup(group);
        }
    }

    public void setChannels(ChannelGroupSettings channels) {
        this.channels_ = channels;
    }

    @Override
    public int getRowCount() {
        if (this.channels_ == null) {
            return 0;
        }
        return this.channels_.getNumChannels();
    }

    @Override
    public int getColumnCount() {
        return COLUMN_NAMES.length;
    }

    @Override
    public String getColumnName(int columnIndex) {
        return COLUMN_NAMES[columnIndex];
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        if (columnIndex == 0) {
            return this.channels_.getChannelListSetting((int)rowIndex).use_;
        }
        if (columnIndex == 1) {
            return this.channels_.getChannelListSetting((int)rowIndex).config_;
        }
        if (columnIndex == 2) {
            return this.channels_.getChannelListSetting((int)rowIndex).exposure_;
        }
        if (columnIndex == 3) {
            return this.channels_.getChannelListSetting((int)rowIndex).offset_;
        }
        throw new RuntimeException();
    }

    public Class getColumnClass(int columnIndex) {
        if (columnIndex == 0) {
            return Boolean.class;
        }
        if (columnIndex == 1) {
            return String.class;
        }
        if (columnIndex == 2) {
            return Double.class;
        }
        if (columnIndex == 3) {
            return Double.class;
        }
        throw new RuntimeException();
    }

    @Override
    public void setValueAt(Object value, int row, int columnIndex) {
        int numCamChannels = (int)this.core_.getNumberOfCameraChannels();
        if (columnIndex == 0) {
            this.channels_.getChannelListSetting((int)row).use_ = (Boolean)value;
            if (numCamChannels > 1) {
                for (int i = row - row % numCamChannels; i < (row / numCamChannels + 1) * numCamChannels; ++i) {
                    this.channels_.getChannelListSetting((int)i).use_ = (Boolean)value;
                }
                this.fireTableDataChanged();
            }
        } else if (columnIndex != 1) {
            if (columnIndex == 2) {
                double val;
                this.channels_.getChannelListSetting((int)row).exposure_ = val = value instanceof String ? Double.parseDouble((String)value) : (Double)value;
                if (numCamChannels > 1) {
                    for (int i = row - row % numCamChannels; i < (row / numCamChannels + 1) * numCamChannels; ++i) {
                        this.channels_.getChannelListSetting((int)i).exposure_ = val;
                    }
                    this.fireTableDataChanged();
                }
            } else if (columnIndex == 3) {
                double val;
                this.channels_.getChannelListSetting((int)row).offset_ = val = value instanceof String ? Double.parseDouble((String)value) : (Double)value;
                if (numCamChannels > 1) {
                    for (int i = row - row % numCamChannels; i < (row / numCamChannels + 1) * numCamChannels; ++i) {
                        this.channels_.getChannelListSetting((int)i).offset_ = val;
                    }
                    this.fireTableDataChanged();
                }
            }
        }
        this.channels_.storeValuesInPrefs();
    }

    @Override
    public boolean isCellEditable(int nRow, int nCol) {
        return nCol != 1;
    }

    @Override
    public void tableChanged(TableModelEvent e) {
    }
}

