/*
 * Decompiled with CFR 0.152.
 */
package org.micromanager.lightsheet;

import java.awt.Point;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Spliterators;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.StreamSupport;
import mmcorej.TaggedImage;
import mmcorej.org.json.JSONObject;
import org.micromanager.acqj.main.AcqEngMetadata;

public class StackResampler {
    public static final int YX_PROJECTION = 0;
    public static final int ORTHOGONAL_VIEWS = 1;
    public static final int FULL_VOLUME = 2;
    private final int mode_;
    private final double reconstructionVoxelSizeUm_;
    private final double[][] transformationMatrix_;
    private double[] reconCoordOffset_;
    private final int[] cameraImageShape_;
    private int[] reconImageShape_;
    private int[][] denominatorYXProjection_;
    private int[][] denominatorZXProjection_;
    private int[][] denominatorYZProjection_;
    private short[] meanProjectionYX_;
    private short[] meanProjectionZX_;
    private short[] meanProjectionYZ_;
    private final Object[][] lineLocks_;
    int[][] sumProjectionYX_ = null;
    int[][] sumProjectionYZ_ = null;
    int[][] sumProjectionZX_ = null;
    short[] maxProjectionYX_ = null;
    short[] maxProjectionYZ_ = null;
    short[] maxProjectionZX_ = null;
    short[][] reconVolumeZYX_ = null;
    private final BlockingQueue<ImagePlusSlice> imageQueue_ = new LinkedBlockingDeque<ImagePlusSlice>();
    private HashMap<Point, ArrayList<Point>> reconCoordLUT_;
    private String settingsKey_;
    private final boolean maxProjection_;

    public StackResampler(int mode, boolean maxProjection, double theta, double cameraPixelSizeXyUm, double sliceDistanceUm, int zPixelShape, int yPixelShape, int xPixelShape) {
        this.mode_ = mode;
        this.maxProjection_ = maxProjection;
        this.settingsKey_ = StackResampler.createSettingsKey(mode, theta, cameraPixelSizeXyUm, sliceDistanceUm, zPixelShape, yPixelShape, xPixelShape);
        this.reconstructionVoxelSizeUm_ = cameraPixelSizeXyUm;
        this.reconCoordOffset_ = new double[2];
        double[][] shearMatrix = new double[][]{{1.0, 0.0}, {Math.tan(1.5707963267948966 - theta), 1.0}};
        double[][] rotationMatrix = new double[][]{{-Math.cos(theta), Math.sin(theta)}, {-Math.sin(theta), -Math.cos(theta)}};
        double[][] cameraPixelToUmMatrix = new double[][]{{sliceDistanceUm * Math.sin(theta), 0.0}, {0.0, cameraPixelSizeXyUm}};
        double[][] reconPixelToUmMatrix = new double[][]{{this.reconstructionVoxelSizeUm_, 0.0}, {0.0, this.reconstructionVoxelSizeUm_}};
        double[][] inverseReconPixelToUmMatrix = LinearTransformation.invert(reconPixelToUmMatrix);
        double[][] transformationMatrix = LinearTransformation.multiply(inverseReconPixelToUmMatrix, rotationMatrix);
        transformationMatrix = LinearTransformation.multiply(transformationMatrix, shearMatrix);
        this.transformationMatrix_ = LinearTransformation.multiply(transformationMatrix, cameraPixelToUmMatrix);
        this.cameraImageShape_ = new int[]{zPixelShape, yPixelShape, xPixelShape};
        this.computeRemappedCoordinateSpace();
        this.precomputeCoordTransformLUTs();
        if (!this.maxProjection_) {
            this.precomputeReconWeightings();
        }
        this.lineLocks_ = new Object[this.reconImageShape_[0]][this.reconImageShape_[1]];
        for (int i = 0; i < this.reconImageShape_[0]; ++i) {
            for (int j = 0; j < this.reconImageShape_[1]; ++j) {
                this.lineLocks_[i][j] = new Object();
            }
        }
    }

    public static String createSettingsKey(int mode, double theta, double cameraPixelSizeXyUm, double sliceDistanceUm, int zPixelShape, int yPixelShape, int xPixelShape) {
        return String.format("%d_%f_%f_%f_%d_%d_%d", mode, theta, cameraPixelSizeXyUm, sliceDistanceUm, zPixelShape, yPixelShape, xPixelShape);
    }

    public String getSettingsKey() {
        return this.settingsKey_;
    }

    private double[] reconCoordsFromCameraCoords(double imageZ, double imageY) {
        double[] reconCoords = LinearTransformation.multiply(this.transformationMatrix_, new double[]{imageZ, imageY});
        reconCoords[0] = reconCoords[0] - this.reconCoordOffset_[0];
        reconCoords[1] = reconCoords[1] - this.reconCoordOffset_[1];
        return reconCoords;
    }

    private double[] cameraCoordsFromReconCoords(double reconZ, double reconY) {
        double[][] inverseTransform = LinearTransformation.invert(this.transformationMatrix_);
        double[] result = LinearTransformation.multiply(inverseTransform, new double[]{reconZ + this.reconCoordOffset_[0], reconY + this.reconCoordOffset_[1]});
        return result;
    }

    private void computeRemappedCoordinateSpace() {
        double[][] corners = new double[][]{{0.0, 0.0}, {0.0, this.cameraImageShape_[1]}, {this.cameraImageShape_[0], 0.0}, {this.cameraImageShape_[0], this.cameraImageShape_[1]}};
        double[][] transformedCorners = new double[corners.length][];
        for (int i = 0; i < corners.length; ++i) {
            transformedCorners[i] = this.reconCoordsFromCameraCoords(corners[i][0], corners[i][1]);
        }
        double[] minTransformedCoordinates = new double[]{Double.MAX_VALUE, Double.MAX_VALUE};
        double[] maxTransformedCoordinates = new double[]{-1.7976931348623157E308, -1.7976931348623157E308};
        for (double[] transformedCorner : transformedCorners) {
            minTransformedCoordinates[0] = Math.min(minTransformedCoordinates[0], transformedCorner[0]);
            minTransformedCoordinates[1] = Math.min(minTransformedCoordinates[1], transformedCorner[1]);
            maxTransformedCoordinates[0] = Math.max(maxTransformedCoordinates[0], transformedCorner[0]);
            maxTransformedCoordinates[1] = Math.max(maxTransformedCoordinates[1], transformedCorner[1]);
        }
        this.reconCoordOffset_[0] = minTransformedCoordinates[0];
        this.reconCoordOffset_[1] = minTransformedCoordinates[1];
        double[] totalTransformedExtent = new double[]{maxTransformedCoordinates[0] - minTransformedCoordinates[0], maxTransformedCoordinates[1] - minTransformedCoordinates[1]};
        this.reconImageShape_ = new int[]{(int)Math.ceil(totalTransformedExtent[0]) + 1, (int)Math.ceil(totalTransformedExtent[1]) + 1, this.cameraImageShape_[2]};
    }

    private void precomputeCoordTransformLUTs() {
        this.reconCoordLUT_ = new HashMap();
        for (int zIndexRecon = 0; zIndexRecon < this.reconImageShape_[0]; ++zIndexRecon) {
            for (int yIndexRecon = 0; yIndexRecon < this.reconImageShape_[1]; ++yIndexRecon) {
                double[] cameraCoords = this.cameraCoordsFromReconCoords(zIndexRecon, yIndexRecon);
                Point cameraCoordsInteger = new Point((int)Math.round(cameraCoords[0]), (int)Math.round(cameraCoords[1]));
                if (cameraCoordsInteger.x < 0 || cameraCoordsInteger.y < 0 || cameraCoordsInteger.x >= this.cameraImageShape_[0] || cameraCoordsInteger.y >= this.cameraImageShape_[1]) continue;
                if (!this.reconCoordLUT_.containsKey(cameraCoordsInteger)) {
                    this.reconCoordLUT_.put(cameraCoordsInteger, new ArrayList());
                }
                this.reconCoordLUT_.get(cameraCoordsInteger).add(new Point(zIndexRecon, yIndexRecon));
            }
        }
    }

    private void precomputeReconWeightings() {
        int j;
        int i;
        int reconShapeZ = this.reconImageShape_[0];
        int reconShapeY = this.reconImageShape_[1];
        int reconShapeX = this.reconImageShape_[2];
        this.denominatorYXProjection_ = new int[reconShapeY][reconShapeX];
        this.denominatorZXProjection_ = new int[reconShapeZ][reconShapeX];
        this.denominatorYZProjection_ = new int[reconShapeY][reconShapeZ];
        for (int zIndexCamera = 0; zIndexCamera < this.cameraImageShape_[0]; ++zIndexCamera) {
            for (int yIndexCamera = 0; yIndexCamera < this.cameraImageShape_[1]; ++yIndexCamera) {
                Point cameraCoords = new Point(zIndexCamera, yIndexCamera);
                if (!this.reconCoordLUT_.containsKey(cameraCoords)) continue;
                ArrayList<Point> reconCoords = this.reconCoordLUT_.get(cameraCoords);
                if (this.mode_ != 1 && this.mode_ != 0) continue;
                for (Point reconCoord : reconCoords) {
                    int reconZIndex = reconCoord.x;
                    int reconYIndex = reconCoord.y;
                    int x = 0;
                    while (x < reconShapeX) {
                        int[] nArray = this.denominatorYXProjection_[reconYIndex];
                        int n = x;
                        nArray[n] = nArray[n] + 1;
                        int[] nArray2 = this.denominatorZXProjection_[reconZIndex];
                        int n2 = x++;
                        nArray2[n2] = nArray2[n2] + 1;
                    }
                    for (x = 0; x < this.cameraImageShape_[2]; ++x) {
                        int[] nArray = this.denominatorYZProjection_[reconYIndex];
                        int n = reconZIndex;
                        nArray[n] = nArray[n] + 1;
                    }
                }
            }
        }
        if (this.mode_ == 1 || this.mode_ == 0) {
            for (i = 0; i < reconShapeY; ++i) {
                for (j = 0; j < reconShapeX; ++j) {
                    if (this.denominatorYXProjection_[i][j] != 0) continue;
                    this.denominatorYXProjection_[i][j] = 1;
                }
            }
        }
        if (this.mode_ == 1) {
            for (i = 0; i < reconShapeZ; ++i) {
                for (j = 0; j < reconShapeX; ++j) {
                    if (this.denominatorZXProjection_[i][j] != 0) continue;
                    this.denominatorZXProjection_[i][j] = 1;
                }
            }
            for (i = 0; i < reconShapeY; ++i) {
                for (j = 0; j < reconShapeZ; ++j) {
                    if (this.denominatorYZProjection_[i][j] != 0) continue;
                    this.denominatorYZProjection_[i][j] = 1;
                }
            }
        }
    }

    public void initializeProjections() {
        this.imageQueue_.clear();
        int reconImageZShape = this.reconImageShape_[0];
        int reconImageYShape = this.reconImageShape_[1];
        int reconImageXShape = this.reconImageShape_[2];
        if (this.mode_ == 0 || this.mode_ == 1) {
            if (this.maxProjection_) {
                this.maxProjectionYX_ = new short[reconImageYShape * reconImageXShape];
                if (this.mode_ == 1) {
                    this.maxProjectionZX_ = new short[reconImageZShape * reconImageXShape];
                    this.maxProjectionYZ_ = new short[reconImageZShape * reconImageYShape];
                }
            } else {
                this.sumProjectionYX_ = new int[reconImageYShape][reconImageXShape];
                if (this.mode_ == 1) {
                    this.sumProjectionZX_ = new int[reconImageZShape][reconImageXShape];
                    this.sumProjectionYZ_ = new int[reconImageYShape][reconImageZShape];
                }
            }
        } else if (this.mode_ == 2) {
            this.reconVolumeZYX_ = new short[reconImageZShape][reconImageYShape * reconImageXShape];
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addImageToRecons(short[] image, int imageSliceIndex) {
        if (image == null) {
            return;
        }
        for (int yIndexCamera = 0; yIndexCamera < this.cameraImageShape_[1]; ++yIndexCamera) {
            if (!this.reconCoordLUT_.containsKey(new Point(imageSliceIndex, yIndexCamera))) continue;
            List destCoords = this.reconCoordLUT_.get(new Point(imageSliceIndex, yIndexCamera));
            int cameraImageWidth = this.cameraImageShape_[2];
            for (Point destCoord : destCoords) {
                int reconZ = destCoord.x;
                int reconY = destCoord.y;
                if (this.mode_ == 2) {
                    System.arraycopy(image, yIndexCamera * cameraImageWidth, this.reconVolumeZYX_[reconZ], reconY * this.reconImageShape_[2], cameraImageWidth);
                }
                if (this.mode_ != 1 && this.mode_ != 0) continue;
                Object object = this.lineLocks_[reconZ][reconY];
                synchronized (object) {
                    for (int reconX = 0; reconX < cameraImageWidth; ++reconX) {
                        if (this.maxProjection_) {
                            this.maxProjectionYX_[reconY * this.reconImageShape_[2] + reconX] = (short)Math.max(this.maxProjectionYX_[reconY * this.reconImageShape_[2] + reconX] & 0xFFFF, image[yIndexCamera * cameraImageWidth + reconX] & 0xFFFF);
                            if (this.mode_ != 1) continue;
                            this.maxProjectionZX_[reconZ * this.reconImageShape_[2] + reconX] = (short)Math.max(this.maxProjectionZX_[reconZ * this.reconImageShape_[2] + reconX] & 0xFFFF, image[yIndexCamera * cameraImageWidth + reconX] & 0xFFFF);
                            this.maxProjectionYZ_[reconY * this.reconImageShape_[0] + reconZ] = (short)Math.max(this.maxProjectionYZ_[reconY * this.reconImageShape_[0] + reconZ] & 0xFFFF, image[yIndexCamera * cameraImageWidth + reconX] & 0xFFFF);
                            continue;
                        }
                        int[] nArray = this.sumProjectionYX_[reconY];
                        int n = reconX;
                        nArray[n] = nArray[n] + (image[yIndexCamera * cameraImageWidth + reconX] & 0xFFFF);
                        if (this.mode_ != 1) continue;
                        int[] nArray2 = this.sumProjectionZX_[reconZ];
                        int n2 = reconX;
                        nArray2[n2] = nArray2[n2] + (image[yIndexCamera * cameraImageWidth + reconX] & 0xFFFF);
                        int[] nArray3 = this.sumProjectionYZ_[reconY];
                        int n3 = reconZ;
                        nArray3[n3] = nArray3[n3] + (image[yIndexCamera * cameraImageWidth + reconX] & 0xFFFF);
                    }
                }
            }
        }
    }

    public void finalizeProjections() {
        if (!this.maxProjection_) {
            if (this.mode_ == 0) {
                this.meanProjectionYX_ = this.divideArrays(this.sumProjectionYX_, this.denominatorYXProjection_);
            }
            if (this.mode_ == 1) {
                this.meanProjectionZX_ = this.divideArrays(this.sumProjectionZX_, this.denominatorZXProjection_);
                this.meanProjectionYZ_ = this.divideArrays(this.sumProjectionYZ_, this.denominatorYZProjection_);
                this.meanProjectionYX_ = this.divideArrays(this.sumProjectionYX_, this.denominatorYXProjection_);
            }
        }
    }

    private short[] divideArrays(int[][] numerator, int[][] denominator) {
        int height = numerator.length;
        int width = numerator[0].length;
        short[] result = new short[height * width];
        for (int i = 0; i < height; ++i) {
            for (int j = 0; j < width; ++j) {
                result[j + width * i] = (short)(numerator[i][j] / denominator[i][j] & 0xFFFF);
            }
        }
        return result;
    }

    public double getReconstructionVoxelSizeUm() {
        return this.reconstructionVoxelSizeUm_;
    }

    public short[] getYXProjection() {
        return this.maxProjection_ ? this.maxProjectionYX_ : this.meanProjectionYX_;
    }

    public short[] getYZProjection() {
        return this.maxProjection_ ? this.maxProjectionYZ_ : this.meanProjectionYZ_;
    }

    public short[] getZXProjection() {
        return this.maxProjection_ ? this.maxProjectionZX_ : this.meanProjectionZX_;
    }

    public short[][] getReconstructedVolumeZYX() {
        return this.reconVolumeZYX_;
    }

    public int getResampledShapeX() {
        return this.reconImageShape_[2];
    }

    public int getResampledShapeY() {
        return this.reconImageShape_[1];
    }

    public int getResampledShapeZ() {
        return this.reconImageShape_[0];
    }

    @Deprecated
    public void addToProcessImageQueue(TaggedImage image) {
        try {
            this.imageQueue_.put(new ImagePlusSlice((short[])image.pix, (Integer)AcqEngMetadata.getAxes((JSONObject)image.tags).get("z")));
        }
        catch (InterruptedException e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }

    public void addToProcessImageQueue(short[] image, int sliceIndex) {
        try {
            this.imageQueue_.put(new ImagePlusSlice(image, sliceIndex));
        }
        catch (InterruptedException e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }

    public Runnable startStackProcessing() {
        Iterator<ImagePlusSlice> iterator = new Iterator<ImagePlusSlice>(){
            private final AtomicInteger processedImages_ = new AtomicInteger(0);
            private volatile boolean stop_ = false;

            @Override
            public boolean hasNext() {
                return !this.stop_ && this.processedImages_.get() < StackResampler.this.cameraImageShape_[0] - 1;
            }

            @Override
            public ImagePlusSlice next() {
                try {
                    ImagePlusSlice element;
                    while ((element = (ImagePlusSlice)StackResampler.this.imageQueue_.poll(1L, TimeUnit.MILLISECONDS)) == null) {
                    }
                    if (element.getPixels() == null) {
                        this.stop_ = true;
                    }
                    this.processedImages_.incrementAndGet();
                    return element;
                }
                catch (InterruptedException e) {
                    throw new RuntimeException(e);
                }
            }
        };
        return () -> StreamSupport.stream(Spliterators.spliterator(iterator, (long)this.cameraImageShape_[0], 1296), true).forEach(imagePlusSlice -> this.addImageToRecons(imagePlusSlice.getPixels(), imagePlusSlice.getFrameNr()));
    }

    public static class LinearTransformation {
        public static double[][] multiply(double[][] firstMatrix, double[][] secondMatrix) {
            int row1 = firstMatrix.length;
            int col1 = firstMatrix[0].length;
            int row2 = secondMatrix.length;
            int col2 = secondMatrix[0].length;
            if (col1 != row2) {
                throw new IllegalArgumentException("Matrix dimensions do not allow multiplication");
            }
            double[][] result = new double[row1][col2];
            for (int i = 0; i < row1; ++i) {
                for (int j = 0; j < col2; ++j) {
                    for (int k = 0; k < col1; ++k) {
                        double[] dArray = result[i];
                        int n = j;
                        dArray[n] = dArray[n] + firstMatrix[i][k] * secondMatrix[k][j];
                    }
                }
            }
            return result;
        }

        public static double[] multiply(double[][] matrix, double[] vector) {
            int row = matrix.length;
            int col = matrix[0].length;
            if (col != vector.length) {
                throw new IllegalArgumentException("Matrix dimensions do not allow multiplication");
            }
            double[] result = new double[row];
            for (int i = 0; i < row; ++i) {
                for (int j = 0; j < col; ++j) {
                    int n = i;
                    result[n] = result[n] + matrix[i][j] * vector[j];
                }
            }
            return result;
        }

        public static double[][] invert(double[][] matrix) {
            if (matrix.length != 2 || matrix[0].length != 2) {
                throw new IllegalArgumentException("Only 2x2 matrices are supported");
            }
            double a = matrix[0][0];
            double d = matrix[1][1];
            double b = matrix[0][1];
            double c = matrix[1][0];
            double det = a * d - b * c;
            if (det == 0.0) {
                throw new IllegalArgumentException("Matrix is not invertible");
            }
            double[][] inverse = new double[][]{{d / det, -b / det}, {-c / det, a / det}};
            return inverse;
        }
    }

    public class ImagePlusSlice {
        private final short[] pixels_;
        private final int sliceNr_;

        public ImagePlusSlice(short[] pixels, int sliceNr) {
            this.pixels_ = pixels;
            this.sliceNr_ = sliceNr;
        }

        public short[] getPixels() {
            return this.pixels_;
        }

        public int getFrameNr() {
            return this.sliceNr_;
        }
    }
}

