/*
 * Decompiled with CFR 0.152.
 */
package org.micromanager.lightsheet;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import mmcorej.TaggedImage;
import mmcorej.org.json.JSONException;
import mmcorej.org.json.JSONObject;
import org.micromanager.acqj.main.AcqEngMetadata;
import org.micromanager.acqj.util.ImageProcessorBase;
import org.micromanager.lightsheet.StackResampler;

class StackResamplersImageProcessor
extends ImageProcessorBase {
    public static final String RESAMPLE_AXIS_NAME = "Resample";
    public static final String YX_PROJECTION = "YX";
    public static final String ZY_PROJECTION = "ZY";
    public static final String ZX_PROJECTION = "ZX";
    public static final String ZYX_INTERPOLATION = "ZYX";
    private ExecutorService processingExecutor_ = new ThreadPoolExecutor(1, 12, 1000L, TimeUnit.MILLISECONDS, new LinkedBlockingDeque<Runnable>());
    private HashMap<HashMap<String, Object>, Future> processingFutures_ = new HashMap();
    private HashMap<String, StackResampler> freeProcessors_ = new HashMap();
    private HashMap<HashMap<String, Object>, StackResampler> activeProcessors_ = new HashMap();
    private final int mode_;
    private final double theta_;
    private final double cameraPixelSizeXyUm_;
    private final double zStep_um_;
    private final int numZStackSlices_;
    private final int cameraImageWidth_;
    private final int cameraImageHeight_;
    private final boolean returnRawDataAlso_;
    private boolean fuseOrthogonalViews_;

    public StackResamplersImageProcessor(int mode, double theta, double cameraPixelSizeXyUm, double zStep_um, int zStackSlices, int cameraImageWidth, int cameraImageHeight, int numProcessorsToPreload, boolean returnRawDataAlso, boolean fuseOrthogonalViews, boolean doMaxProjection) {
        this.mode_ = mode;
        this.theta_ = theta;
        this.cameraPixelSizeXyUm_ = cameraPixelSizeXyUm;
        this.fuseOrthogonalViews_ = fuseOrthogonalViews;
        this.zStep_um_ = zStep_um;
        this.numZStackSlices_ = zStackSlices;
        this.cameraImageWidth_ = cameraImageWidth;
        this.cameraImageHeight_ = cameraImageHeight;
        this.returnRawDataAlso_ = returnRawDataAlso;
        for (int i = 0; i < numProcessorsToPreload; ++i) {
            StackResampler s = new StackResampler(this.mode_, doMaxProjection, this.theta_, this.cameraPixelSizeXyUm_, this.zStep_um_, this.numZStackSlices_, this.cameraImageWidth_, this.cameraImageHeight_);
            this.freeProcessors_.put(s.getSettingsKey(), s);
        }
    }

    BlockingQueue<TaggedImage> getOutputQueue() {
        return this.sink_;
    }

    public int getResampledShapeX() {
        StackResampler s = this.freeProcessors_.size() > 0 ? this.freeProcessors_.values().iterator().next() : this.activeProcessors_.values().iterator().next();
        return s.getResampledShapeX();
    }

    public int getResampledShapeY() {
        StackResampler s = this.freeProcessors_.size() > 0 ? this.freeProcessors_.values().iterator().next() : this.activeProcessors_.values().iterator().next();
        return s.getResampledShapeY();
    }

    public int getResampledShapeZ() {
        StackResampler s = this.freeProcessors_.size() > 0 ? this.freeProcessors_.values().iterator().next() : this.activeProcessors_.values().iterator().next();
        return s.getResampledShapeZ();
    }

    protected TaggedImage processImage(TaggedImage img) {
        try {
            int zIndex = (Integer)AcqEngMetadata.getAxes((JSONObject)img.tags).get("z");
            HashMap nonZAxes = AcqEngMetadata.getAxes((JSONObject)img.tags);
            nonZAxes.remove("z");
            if (img.tags == null && img.pix == null) {
                for (StackResampler p : this.activeProcessors_.values()) {
                    p.addToProcessImageQueue((short[])img.pix, (Integer)AcqEngMetadata.getAxes((JSONObject)img.tags).get("z"));
                }
                this.processingExecutor_.shutdown();
                return null;
            }
            String settingsKey = StackResampler.createSettingsKey(this.mode_, this.theta_, this.cameraPixelSizeXyUm_, this.zStep_um_, this.numZStackSlices_, this.cameraImageWidth_, this.cameraImageHeight_);
            if (zIndex == 0) {
                StackResampler processor = this.freeProcessors_.getOrDefault(settingsKey, null);
                this.activeProcessors_.put(nonZAxes, processor);
                processor.initializeProjections();
                Future<?> f = this.processingExecutor_.submit(processor.startStackProcessing());
                this.processingFutures_.put(nonZAxes, f);
                processor.addToProcessImageQueue((short[])img.pix, (Integer)AcqEngMetadata.getAxes((JSONObject)img.tags).get("z"));
            } else if (zIndex == this.numZStackSlices_ - 1) {
                StackResampler processor = this.activeProcessors_.get(nonZAxes);
                processor.addToProcessImageQueue((short[])img.pix, (Integer)AcqEngMetadata.getAxes((JSONObject)img.tags).get("z"));
                this.processingFutures_.get(nonZAxes).get();
                this.processingFutures_.remove(nonZAxes);
                processor.finalizeProjections();
                if (this.mode_ == 0) {
                    this.addToOutputQueue(this.generateYXProjectionTaggedImage(processor, img));
                } else if (this.mode_ == 1) {
                    if (this.fuseOrthogonalViews_) {
                        this.addToOutputQueue(this.generateFusedOrthogonalViews(processor, img));
                    } else {
                        this.addToOutputQueue(this.generateYXProjectionTaggedImage(processor, img));
                        this.addToOutputQueue(this.generateYZProjectionTaggedImage(processor, img));
                        this.addToOutputQueue(this.generateZXProjectionTaggedImage(processor, img));
                    }
                } else if (this.mode_ == 2) {
                    for (TaggedImage zSlice : this.generateReconstructedVolume(processor, img)) {
                        this.addToOutputQueue(zSlice);
                    }
                } else {
                    throw new RuntimeException("Unknown mode: " + this.mode_);
                }
                this.activeProcessors_.remove(nonZAxes);
                this.freeProcessors_.put(settingsKey, processor);
            } else {
                this.activeProcessors_.get(nonZAxes).addToProcessImageQueue((short[])img.pix, (Integer)AcqEngMetadata.getAxes((JSONObject)img.tags).get("z"));
            }
            return this.returnRawDataAlso_ ? img : null;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }

    private TaggedImage generateFusedOrthogonalViews(StackResampler processor, TaggedImage img) throws JSONException {
        int j;
        int i;
        JSONObject newTags = new JSONObject(img.tags.toString());
        if (newTags.has("ZPosition_um_Intended")) {
            newTags.remove("ZPosition_um_Intended");
        }
        AcqEngMetadata.setAxisPosition((JSONObject)newTags, (String)"z", null);
        short[] yx = processor.getYXProjection();
        short[] yz = processor.getYZProjection();
        short[] zx = processor.getZXProjection();
        int xSize = processor.getResampledShapeX();
        int ySize = processor.getResampledShapeY();
        int zSize = processor.getResampledShapeZ();
        int fusedWidth = xSize + zSize;
        int fusedHeight = ySize + zSize;
        short[] fused = new short[fusedWidth * fusedHeight];
        for (i = 0; i < ySize; ++i) {
            for (j = 0; j < xSize; ++j) {
                fused[i * fusedWidth + j] = (short)(yx[i * xSize + j] & 0xFFFF);
            }
        }
        for (i = 0; i < ySize; ++i) {
            for (j = 0; j < zSize; ++j) {
                fused[i * fusedWidth + (j + xSize)] = (short)(yz[i + ySize * j] & 0xFFFF);
            }
        }
        for (i = 0; i < zSize; ++i) {
            for (j = 0; j < xSize; ++j) {
                fused[(i + ySize) * fusedWidth + j] = (short)(zx[i * xSize + j] & 0xFFFF);
            }
        }
        AcqEngMetadata.setHeight((JSONObject)newTags, (int)fusedHeight);
        AcqEngMetadata.setWidth((JSONObject)newTags, (int)fusedWidth);
        AcqEngMetadata.setAxisPosition((JSONObject)newTags, (String)RESAMPLE_AXIS_NAME, (Object)ZX_PROJECTION);
        return new TaggedImage((Object)fused, newTags);
    }

    private ArrayList<TaggedImage> generateReconstructedVolume(StackResampler processor, TaggedImage img) throws JSONException {
        ArrayList<TaggedImage> volume = new ArrayList<TaggedImage>();
        double reconZStep = processor.getReconstructionVoxelSizeUm();
        short[][] reconstructedVolume = processor.getReconstructedVolumeZYX();
        for (int z = 0; z < reconstructedVolume.length; ++z) {
            JSONObject newTags = new JSONObject(img.tags.toString());
            AcqEngMetadata.setStageZIntended((JSONObject)newTags, (double)((double)z * reconZStep));
            AcqEngMetadata.setAxisPosition((JSONObject)newTags, (String)"z", (Object)z);
            AcqEngMetadata.setHeight((JSONObject)newTags, (int)processor.getResampledShapeY());
            AcqEngMetadata.setWidth((JSONObject)newTags, (int)processor.getResampledShapeX());
            AcqEngMetadata.setAxisPosition((JSONObject)newTags, (String)RESAMPLE_AXIS_NAME, (Object)ZYX_INTERPOLATION);
            volume.add(new TaggedImage((Object)reconstructedVolume[z], newTags));
        }
        return volume;
    }

    private TaggedImage generateZXProjectionTaggedImage(StackResampler processor, TaggedImage img) throws JSONException {
        JSONObject newTags = new JSONObject(img.tags.toString());
        if (newTags.has("ZPosition_um_Intended")) {
            newTags.remove("ZPosition_um_Intended");
        }
        AcqEngMetadata.setAxisPosition((JSONObject)newTags, (String)"z", null);
        AcqEngMetadata.setHeight((JSONObject)newTags, (int)processor.getResampledShapeZ());
        AcqEngMetadata.setWidth((JSONObject)newTags, (int)processor.getResampledShapeX());
        AcqEngMetadata.setAxisPosition((JSONObject)newTags, (String)RESAMPLE_AXIS_NAME, (Object)ZX_PROJECTION);
        return new TaggedImage((Object)processor.getZXProjection(), newTags);
    }

    private TaggedImage generateYZProjectionTaggedImage(StackResampler processor, TaggedImage img) throws JSONException {
        JSONObject newTags = new JSONObject(img.tags.toString());
        if (newTags.has("ZPosition_um_Intended")) {
            newTags.remove("ZPosition_um_Intended");
        }
        AcqEngMetadata.setAxisPosition((JSONObject)newTags, (String)"z", null);
        AcqEngMetadata.setHeight((JSONObject)newTags, (int)processor.getResampledShapeZ());
        AcqEngMetadata.setWidth((JSONObject)newTags, (int)processor.getResampledShapeY());
        AcqEngMetadata.setAxisPosition((JSONObject)newTags, (String)RESAMPLE_AXIS_NAME, (Object)ZY_PROJECTION);
        return new TaggedImage((Object)processor.getYZProjection(), newTags);
    }

    private TaggedImage generateYXProjectionTaggedImage(StackResampler processor, TaggedImage img) throws JSONException {
        JSONObject newTags = new JSONObject(img.tags.toString());
        if (newTags.has("ZPosition_um_Intended")) {
            newTags.remove("ZPosition_um_Intended");
        }
        AcqEngMetadata.setAxisPosition((JSONObject)newTags, (String)"z", null);
        AcqEngMetadata.setHeight((JSONObject)newTags, (int)processor.getResampledShapeY());
        AcqEngMetadata.setWidth((JSONObject)newTags, (int)processor.getResampledShapeX());
        AcqEngMetadata.setAxisPosition((JSONObject)newTags, (String)RESAMPLE_AXIS_NAME, (Object)YX_PROJECTION);
        return new TaggedImage((Object)processor.getYXProjection(), newTags);
    }
}

