/*
 * Decompiled with CFR 0.152.
 */
package org.micromanager.remote;

import java.awt.Color;
import java.io.UnsupportedEncodingException;
import java.net.URISyntaxException;
import java.util.HashSet;
import java.util.function.Function;
import javax.swing.UIManager;
import javax.swing.plaf.ColorUIResource;
import mmcorej.CMMCore;
import org.micromanager.acqj.internal.Engine;
import org.micromanager.pyjavaz.ZMQServer;

public class HeadlessLauncher {
    private static Engine engine_;
    private static ZMQServer zmqServer_;
    private static final String BACKGROUND_MODE = "current window style (as per ApplicationSkin.SkinMode)";
    private static final String[] BACKGROUND_COLOR_KEYS;
    private static final String[] LIGHTER_BACKGROUND_COLOR_KEYS;
    private static final String[] ENABLED_TEXT_COLOR_KEYS;
    private static final String[] DISABLED_TEXT_COLOR_KEYS;
    private static final String[] MANUAL_TEXT_COLOR_KEYS;
    private static final String[] MANUAL_BACKGROUND_COLOR_KEYS;

    public static void main(String[] args) throws Exception {
        HeadlessLauncher.darkUI();
        final CMMCore core = new CMMCore();
        core.waitForSystem();
        int port = Integer.parseInt(args[0]);
        String configFilePath = args[1];
        int bufferSizeMB = Integer.parseInt(args[2]);
        String coreLogPath = args[3];
        if (configFilePath != null && configFilePath.length() != 0) {
            core.loadSystemConfiguration(configFilePath);
        }
        core.setCircularBufferMemoryFootprint((long)bufferSizeMB);
        core.enableStderrLog(true);
        core.enableDebugLog(true);
        core.setPrimaryLogFile(coreLogPath);
        engine_ = new Engine(core);
        Function<Class, Object> instanceGrabberFunction = new Function<Class, Object>(){

            @Override
            public Object apply(Class baseClass) {
                if (baseClass.equals(CMMCore.class)) {
                    return core;
                }
                return null;
            }
        };
        try {
            HashSet<ClassLoader> classLoaders = new HashSet<ClassLoader>();
            classLoaders.add(core.getClass().getClassLoader());
            zmqServer_ = new ZMQServer(classLoaders, (Function)instanceGrabberFunction, new String[0], s -> System.out.println((String)s), port);
            System.out.println("STARTED");
        }
        catch (URISyntaxException e) {
            throw new RuntimeException();
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException();
        }
    }

    public static void darkUI() {
        ColorUIResource backgroundMode = new ColorUIResource(new Color(64, 64, 64));
        ColorUIResource disabledTextColor = new ColorUIResource(120, 120, 120);
        ColorUIResource enabledTextColor = new ColorUIResource(200, 200, 200);
        ColorUIResource lightBackground = new ColorUIResource(new Color(96, 96, 96));
        for (String key : BACKGROUND_COLOR_KEYS) {
            UIManager.put(key + ".background", backgroundMode);
        }
        for (String key : LIGHTER_BACKGROUND_COLOR_KEYS) {
            UIManager.put(key + ".background", lightBackground);
        }
        for (String key : MANUAL_TEXT_COLOR_KEYS) {
            UIManager.put(key, enabledTextColor);
        }
        for (String key : MANUAL_BACKGROUND_COLOR_KEYS) {
            UIManager.put(key, backgroundMode);
        }
        for (String key : ENABLED_TEXT_COLOR_KEYS) {
            UIManager.put(key + ".foreground", enabledTextColor);
            UIManager.put(key + ".caretForeground", enabledTextColor);
        }
        for (String key : DISABLED_TEXT_COLOR_KEYS) {
            UIManager.put(key + ".disabledText", disabledTextColor);
        }
    }

    static {
        BACKGROUND_COLOR_KEYS = new String[]{"Button", "CheckBox", "ColorChooser", "EditorPane", "FormattedTextField", "InternalFrame", "Label", "List", "MenuBar", "OptionPane", "Panel", "PasswordField", "ProgressBar", "RadioButton", "ScrollBar", "ScrollPane", "Slider", "Spinner", "SplitPane", "Table", "TableHeader", "TextArea", "TextField", "TextPane", "ToggleButton", "ToolBar", "Tree", "Viewport"};
        LIGHTER_BACKGROUND_COLOR_KEYS = new String[]{"CheckBoxMenuItem", "ComboBox", "Menu", "MenuItem", "PopupMenu", "RadioButtonMenuItem"};
        ENABLED_TEXT_COLOR_KEYS = new String[]{"CheckBox", "ColorChooser", "FormattedTextField", "InternalFrame", "Label", "List", "OptionPane", "Panel", "ProgressBar", "RadioButton", "ScrollPane", "Separator", "Slider", "Spinner", "SplitPane", "Table", "TableHeader", "TextArea", "TextField", "TextPane", "ToolBar", "Tree", "Viewport"};
        DISABLED_TEXT_COLOR_KEYS = new String[]{"Button", "CheckBox", "RadioButton", "ToggleButton"};
        MANUAL_TEXT_COLOR_KEYS = new String[]{"Tree.textForeground", "TitledBorder.titleColor", "OptionPane.messageForeground"};
        MANUAL_BACKGROUND_COLOR_KEYS = new String[]{"ComboBox.buttonBackground", "Tree.textBackground"};
    }
}

