/*
 * Decompiled with CFR 0.152.
 */
package org.micromanager.remote;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import mmcorej.org.json.JSONArray;
import mmcorej.org.json.JSONException;
import mmcorej.org.json.JSONObject;
import org.micromanager.acqj.api.AcquisitionAPI;
import org.micromanager.acqj.api.AcquisitionHook;
import org.micromanager.acqj.main.AcquisitionEvent;
import org.micromanager.pyjavaz.ZMQPullSocket;
import org.micromanager.pyjavaz.ZMQPushSocket;

public class RemoteAcqHook
implements AcquisitionHook {
    ZMQPushSocket<AcquisitionEvent> pushSocket_ = new ZMQPushSocket((Function)new Function<AcquisitionEvent, JSONObject>(){

        @Override
        public JSONObject apply(AcquisitionEvent t) {
            return t.toJSON();
        }
    });
    ZMQPullSocket<List<AcquisitionEvent>> pullSocket_;

    public RemoteAcqHook(final AcquisitionAPI acq) {
        this.pullSocket_ = new ZMQPullSocket((Function)new Function<JSONObject, List<AcquisitionEvent>>(){

            @Override
            public List<AcquisitionEvent> apply(JSONObject t) {
                try {
                    ArrayList<AcquisitionEvent> eventList = new ArrayList<AcquisitionEvent>();
                    if (t.has("events")) {
                        JSONArray events = t.getJSONArray("events");
                        for (int i = 0; i < events.length(); ++i) {
                            JSONObject e = events.getJSONObject(i);
                            eventList.add(AcquisitionEvent.fromJSON((JSONObject)e, (AcquisitionAPI)acq));
                        }
                    } else {
                        eventList.add(AcquisitionEvent.fromJSON((JSONObject)t, (AcquisitionAPI)acq));
                    }
                    return eventList;
                }
                catch (JSONException ex) {
                    throw new RuntimeException("Incorrect format for acquisitio event");
                }
            }
        });
    }

    public AcquisitionEvent run(AcquisitionEvent event) {
        this.pushSocket_.push((Object)event);
        List ae = (List)this.pullSocket_.next();
        if (ae.size() == 1) {
            return (AcquisitionEvent)ae.get(0);
        }
        return new AcquisitionEvent(ae);
    }

    public int getPullPort() {
        return this.pullSocket_.getPort();
    }

    public int getPushPort() {
        return this.pushSocket_.getPort();
    }

    public void close() {
        this.pushSocket_.close();
        this.pullSocket_.close();
    }
}

