/*
 * Decompiled with CFR 0.152.
 */
package org.micromanager.remote;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import mmcorej.org.json.JSONArray;
import mmcorej.org.json.JSONException;
import mmcorej.org.json.JSONObject;
import org.micromanager.acqj.api.AcquisitionAPI;
import org.micromanager.acqj.main.Acquisition;
import org.micromanager.acqj.main.AcquisitionEvent;
import org.micromanager.pyjavaz.ZMQPullSocket;

public class RemoteEventSource {
    private ZMQPullSocket<List<AcquisitionEvent>> pullSocket_;
    private Acquisition acq_;
    private ExecutorService executor_ = Executors.newSingleThreadExecutor(r -> new Thread(r, "Remote Event Source thread"));

    public RemoteEventSource() {
        this.executor_.submit(() -> {
            this.pullSocket_ = new ZMQPullSocket(t -> {
                try {
                    ArrayList<AcquisitionEvent> eventList = new ArrayList<AcquisitionEvent>();
                    JSONArray events = t.getJSONArray("events");
                    for (int i = 0; i < events.length(); ++i) {
                        JSONObject e = events.getJSONObject(i);
                        eventList.add(AcquisitionEvent.fromJSON((JSONObject)e, (AcquisitionAPI)this.acq_));
                    }
                    return eventList;
                }
                catch (JSONException ex) {
                    throw new RuntimeException("Incorrect format for acquisitio event");
                }
            });
            try {
                boolean finished;
                do {
                    List eList = (List)this.pullSocket_.next();
                    finished = ((AcquisitionEvent)eList.get(eList.size() - 1)).isAcquisitionFinishedEvent();
                    Future result = this.acq_.submitEventIterator(eList.iterator());
                    result.get();
                } while (!finished && !this.executor_.isShutdown());
                this.executor_.shutdown();
            }
            catch (InterruptedException eList) {
            }
            catch (Exception e) {
                e.printStackTrace();
                if (!this.executor_.isShutdown()) {
                    this.acq_.abort(e);
                }
            }
            finally {
                this.pullSocket_.close();
            }
        });
    }

    void setAcquisition(Acquisition aThis) {
        this.acq_ = aThis;
    }

    public int getPort() {
        while (this.pullSocket_ == null) {
            try {
                Thread.sleep(1L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        return this.pullSocket_.getPort();
    }

    public boolean isFinished() {
        return this.executor_.isTerminated();
    }

    void abort() {
        this.executor_.shutdown();
        while (!this.executor_.isTerminated()) {
            try {
                Thread.sleep(1L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }
}

