/*
 * Decompiled with CFR 0.152.
 */
package org.micromanager.remote;

import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.function.Function;
import mmcorej.TaggedImage;
import mmcorej.org.json.JSONException;
import mmcorej.org.json.JSONObject;
import org.micromanager.acqj.api.AcquisitionAPI;
import org.micromanager.acqj.api.TaggedImageProcessor;
import org.micromanager.acqj.main.AcqEngMetadata;
import org.micromanager.pyjavaz.ZMQPullSocket;
import org.micromanager.pyjavaz.ZMQPushSocket;
import org.micromanager.pyjavaz.ZMQUtil;

public class RemoteImageProcessor
implements TaggedImageProcessor {
    private ExecutorService pushExecutor_;
    private ExecutorService pullExecutor_;
    volatile BlockingQueue<TaggedImage> source_;
    volatile BlockingQueue<TaggedImage> sink_;
    ZMQPushSocket<TaggedImage> pushSocket_ = new ZMQPushSocket((Function)new Function<TaggedImage, JSONObject>(){

        @Override
        public JSONObject apply(TaggedImage t) {
            try {
                JSONObject json = new JSONObject();
                if (t.tags == null && t.pix == null) {
                    json.put("special", (Object)"finished");
                } else {
                    json.put("metadata", (Object)t.tags);
                    json.put("pixels", (Object)ZMQUtil.toJSON((Object)t.pix));
                }
                return json;
            }
            catch (JSONException ex) {
                throw new RuntimeException(ex);
            }
        }
    });
    ZMQPullSocket<TaggedImage> pullSocket_ = new ZMQPullSocket((Function)new Function<JSONObject, TaggedImage>(){

        @Override
        public TaggedImage apply(JSONObject t) {
            try {
                JSONObject tags;
                if (t instanceof JSONObject && t.has("special") && t.getString("special").equals("finished")) {
                    return new TaggedImage(null, null);
                }
                Object pix = ZMQUtil.decodeArray((byte[])((byte[])t.get("pixels")), AcqEngMetadata.getBytesPerPixel((JSONObject)(tags = t.getJSONObject("metadata"))) == 1 || AcqEngMetadata.getBytesPerPixel((JSONObject)tags) == 4 ? byte[].class : short[].class);
                return new TaggedImage(pix, tags);
            }
            catch (JSONException ex) {
                throw new RuntimeException(ex);
            }
        }
    });

    public RemoteImageProcessor() {
        this.pushExecutor_ = Executors.newSingleThreadExecutor(r -> new Thread(r, "Tagged Image socket push"));
        this.pullExecutor_ = Executors.newSingleThreadExecutor(r -> new Thread(r, "Tagged Image socket pull"));
    }

    public int getPullPort() {
        return this.pullSocket_.getPort();
    }

    public int getPushPort() {
        return this.pushSocket_.getPort();
    }

    public void startPush() {
        this.pushExecutor_.submit(() -> {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [3[UNCONDITIONALDOLOOP]], but top level block is 0[TRYBLOCK]
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1050)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        });
    }

    public void startPull() {
        this.pullExecutor_.submit(() -> {
            while (true) {
                if (this.sink_ == null) {
                    continue;
                }
                try {
                    TaggedImage ti = (TaggedImage)this.pullSocket_.next();
                    this.sink_.put(ti);
                    if (ti.pix != null || ti.tags != null) continue;
                    this.pullExecutor_.shutdown();
                }
                catch (InterruptedException ex) {
                    return;
                }
                catch (Exception e) {
                    if (this.pullExecutor_.isShutdown()) {
                        return;
                    }
                    e.printStackTrace();
                    continue;
                }
                break;
            }
            this.pullSocket_.close();
        });
    }

    public void setAcqAndDequeues(AcquisitionAPI acq, LinkedBlockingDeque<TaggedImage> source, LinkedBlockingDeque<TaggedImage> sink) {
    }

    public void setAcqAndQueues(AcquisitionAPI acq, BlockingQueue<TaggedImage> source, BlockingQueue<TaggedImage> sink) {
        this.source_ = source;
        this.sink_ = sink;
    }
}

