/*
 * Decompiled with CFR 0.152.
 */
package org.micromanager.remote;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingDeque;
import mmcorej.org.json.JSONException;
import org.micromanager.acqj.api.AcqNotificationListener;
import org.micromanager.acqj.api.AcquisitionAPI;
import org.micromanager.acqj.main.AcqNotification;
import org.micromanager.pyjavaz.ZMQPushSocket;

public class RemoteNotificationHandler
implements AcqNotificationListener {
    private ZMQPushSocket<AcqNotification> pushSocket_;
    private ExecutorService executor_ = Executors.newSingleThreadExecutor(r -> new Thread(r, "Remote notification thread"));
    private LinkedBlockingDeque<AcqNotification> notifications_ = new LinkedBlockingDeque();

    public RemoteNotificationHandler(AcquisitionAPI acq) {
        acq.addAcqNotificationListener((AcqNotificationListener)this);
        this.executor_.submit(new Runnable(){

            @Override
            public void run() {
                RemoteNotificationHandler.this.pushSocket_ = new ZMQPushSocket(t -> {
                    try {
                        return t.toJSON();
                    }
                    catch (JSONException e) {
                        throw new RuntimeException("Problem with notification socket");
                    }
                });
            }
        });
    }

    public void start() {
        this.executor_.submit(() -> {
            boolean eventsFinished = false;
            boolean dataSinkFinished = false;
            do {
                AcqNotification e = null;
                try {
                    e = this.notifications_.takeFirst();
                }
                catch (InterruptedException ex) {
                    ex.printStackTrace();
                    throw new RuntimeException(ex);
                }
                this.pushSocket_.push((Object)e);
                if (e.isAcquisitionEventsFinishedNotification()) {
                    eventsFinished = true;
                }
                if (!e.isDataSinkFinishedNotification()) continue;
                dataSinkFinished = true;
            } while (!eventsFinished || !dataSinkFinished);
        });
    }

    public void postNotification(AcqNotification n) {
        this.notifications_.add(n);
    }

    public void notificationHandlingComplete() {
        this.executor_.submit(() -> {
            this.pushSocket_.close();
            this.executor_.shutdown();
        });
    }

    public int getPort() {
        while (this.pushSocket_ == null) {
            try {
                Thread.sleep(1L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        return this.pushSocket_.getPort();
    }
}

