/*
 * Decompiled with CFR 0.152.
 */
package org.microbean.configuration.api;

import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import org.microbean.configuration.api.ConfigurationException;
import org.microbean.configuration.api.ConfigurationValue;

public class AmbiguousConfigurationValuesException
extends ConfigurationException {
    private static final long serialVersionUID = 1L;
    private final Collection<? extends ConfigurationValue> values;
    private final Map<? extends String, ? extends String> configurationCoordinates;
    private final String name;

    public AmbiguousConfigurationValuesException(String message, Throwable cause, Map<? extends String, ? extends String> configurationCoordinates, String name, Collection<? extends ConfigurationValue> values) {
        super(message, cause);
        if (name == null) {
            NullPointerException throwMe = new NullPointerException();
            throwMe.addSuppressed(this);
            throw throwMe;
        }
        this.configurationCoordinates = configurationCoordinates == null ? Collections.emptyMap() : Collections.unmodifiableMap(configurationCoordinates);
        this.name = name;
        this.values = values == null ? Collections.emptySet() : values;
    }

    public final Collection<? extends ConfigurationValue> getValues() {
        return this.values;
    }

    public final Map<? extends String, ? extends String> getCoordinates() {
        return this.configurationCoordinates;
    }

    public final String getName() {
        return this.name;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder(super.toString());
        sb.append(" ");
        sb.append(this.getCoordinates());
        sb.append(" ");
        sb.append(this.getName());
        sb.append(" \u27a1 ");
        sb.append(this.getValues());
        return sb.toString();
    }
}

