/*
 * Decompiled with CFR 0.152.
 */
package org.microbean.configuration.api;

import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public class ConfigurationValue
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Serializable source;
    private final Map<String, String> coordinates;
    private final String name;
    private final String value;
    private final boolean authoritative;

    public ConfigurationValue(Serializable source, Map<String, String> coordinates, String name, String value, boolean authoritative) {
        Objects.requireNonNull(source);
        Objects.requireNonNull(name);
        this.source = source;
        this.coordinates = coordinates == null || coordinates.isEmpty() ? Collections.emptyMap() : Collections.unmodifiableMap(new HashMap<String, String>(coordinates));
        this.name = name;
        this.value = value;
        this.authoritative = authoritative;
    }

    public final Object getSource() {
        return this.source;
    }

    public final Map<String, String> getCoordinates() {
        return this.coordinates;
    }

    public final String getName() {
        return this.name;
    }

    public final String getValue() {
        return this.value;
    }

    public final boolean isAuthoritative() {
        return this.authoritative;
    }

    public final int specificity() {
        int size = 0;
        Map<String, String> coordinates = this.getCoordinates();
        if (coordinates != null) {
            size = coordinates.size();
        }
        return size;
    }

    public int hashCode() {
        int hashCode = 17;
        Map<String, String> coordinates = this.getCoordinates();
        int c = coordinates == null ? 0 : ((Object)coordinates).hashCode();
        hashCode = 37 * hashCode + c;
        String name = this.getName();
        c = name == null ? 0 : name.hashCode();
        hashCode = 37 * hashCode + c;
        String value = this.getValue();
        c = value == null ? 0 : value.hashCode();
        hashCode = 37 * hashCode + c;
        return hashCode;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (other instanceof ConfigurationValue) {
            ConfigurationValue her = (ConfigurationValue)other;
            Map<String, String> coordinates = this.getCoordinates();
            if (coordinates == null ? her.getCoordinates() != null : !((Object)coordinates).equals(her.getCoordinates())) {
                return false;
            }
            String name = this.getName();
            if (name == null ? her.getName() != null : !name.equals(her.getName())) {
                return false;
            }
            String value = this.getValue();
            return !(value == null ? her.getValue() != null : !value.equals(her.getValue()));
        }
        return false;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append(this.getSource());
        sb.append(") ");
        Map<String, String> coordinates = this.getCoordinates();
        if (coordinates != null && !coordinates.isEmpty()) {
            sb.append(coordinates);
            sb.append(" ");
        }
        sb.append(this.getName());
        sb.append("=");
        sb.append(this.getValue());
        boolean authoritative = this.isAuthoritative();
        if (authoritative) {
            sb.append(" (authoritative)");
        }
        return sb.toString();
    }
}

