/*
 * Decompiled with CFR 0.152.
 */
package org.microbean.configuration.api;

import java.lang.reflect.Type;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.ServiceConfigurationError;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.microbean.configuration.api.ConfigurationException;
import org.microbean.configuration.api.TypeLiteral;

public abstract class Configurations {
    private static volatile ServiceLoader<Configurations> configurationsLoader;
    protected final Logger logger = this.createLogger();

    protected Configurations() {
        if (this.logger == null) {
            throw new IllegalStateException("createLogger() == null");
        }
    }

    protected Logger createLogger() {
        return Logger.getLogger(this.getClass().getName());
    }

    public abstract Set<Type> getConversionTypes();

    public abstract Map<String, String> getConfigurationCoordinates();

    public final String getValue(String name) {
        return this.getValue(this.getConfigurationCoordinates(), name, String.class, null);
    }

    public final String getValue(String name, String defaultValue) {
        return this.getValue(this.getConfigurationCoordinates(), name, String.class, defaultValue);
    }

    public final String getValue(Map<String, String> configurationCoordinates, String name) {
        return this.getValue(configurationCoordinates, name, String.class, null);
    }

    public final String getValue(Map<String, String> configurationCoordinates, String name, String defaultValue) {
        return this.getValue(configurationCoordinates, name, String.class, defaultValue);
    }

    public final <T> T getValue(String name, Class<T> type) {
        return this.getValue(this.getConfigurationCoordinates(), name, type, null);
    }

    public final <T> T getValue(String name, Class<T> type, String defaultValue) {
        return this.getValue(this.getConfigurationCoordinates(), name, type, defaultValue);
    }

    public final <T> T getValue(Map<String, String> configurationCoordinates, String name, Class<T> type) {
        return this.getValue(configurationCoordinates, name, (Type)type, null);
    }

    public final <T> T getValue(Map<String, String> configurationCoordinates, String name, Class<T> type, String defaultValue) {
        return this.getValue(configurationCoordinates, name, (Type)type, defaultValue);
    }

    public final <T> T getValue(String name, TypeLiteral<T> typeLiteral) {
        return this.getValue(this.getConfigurationCoordinates(), name, typeLiteral, null);
    }

    public final <T> T getValue(String name, TypeLiteral<T> typeLiteral, String defaultValue) {
        return this.getValue(this.getConfigurationCoordinates(), name, typeLiteral, defaultValue);
    }

    public final <T> T getValue(Map<String, String> configurationCoordinates, String name, TypeLiteral<T> typeLiteral) {
        return this.getValue(configurationCoordinates, name, typeLiteral == null ? (Type)null : typeLiteral.getType(), null);
    }

    public final <T> T getValue(Map<String, String> configurationCoordinates, String name, TypeLiteral<T> typeLiteral, String defaultValue) {
        return this.getValue(configurationCoordinates, name, typeLiteral == null ? (Type)null : typeLiteral.getType(), defaultValue);
    }

    public final <T> T getValue(String name, Type type) {
        return this.getValue(this.getConfigurationCoordinates(), name, type, null);
    }

    public final <T> T getValue(String name, Type type, String defaultValue) {
        return this.getValue(this.getConfigurationCoordinates(), name, type, defaultValue);
    }

    public final <T> T getValue(Map<String, String> configurationCoordinates, String name, Type type) {
        return this.getValue(configurationCoordinates, name, type, null);
    }

    public abstract <T> T getValue(Map<String, String> var1, String var2, Type var3, String var4);

    public final String getValue(Map<String, String> configurationCoordinates, Collection<String> names, String defaultValue) {
        return this.getValue(configurationCoordinates, names, String.class, defaultValue);
    }

    public final String getValue(Map<String, String> configurationCoordinates, Collection<String> names) {
        return this.getValue(configurationCoordinates, names, String.class, null);
    }

    public final String getValue(Collection<String> names) {
        return this.getValue(this.getConfigurationCoordinates(), names, String.class, null);
    }

    public final String getValue(Collection<String> names, String defaultValue) {
        return this.getValue(this.getConfigurationCoordinates(), names, String.class, defaultValue);
    }

    public final <T> T getValue(Collection<String> names, Class<T> type, String defaultValue) {
        return this.getValue(this.getConfigurationCoordinates(), names, type, defaultValue);
    }

    public final <T> T getValue(Collection<String> names, Type type, String defaultValue) {
        return this.getValue(this.getConfigurationCoordinates(), names, type, defaultValue);
    }

    public final <T> T getValue(Collection<String> names, TypeLiteral<T> typeLiteral, String defaultValue) {
        return this.getValue(this.getConfigurationCoordinates(), names, typeLiteral == null ? (Type)null : typeLiteral.getType(), defaultValue);
    }

    public final <T> T getValue(Collection<String> names, Class<T> type) {
        return this.getValue(this.getConfigurationCoordinates(), names, type, null);
    }

    public final <T> T getValue(Collection<String> names, Type type) {
        return this.getValue(this.getConfigurationCoordinates(), names, type, null);
    }

    public final <T> T getValue(Collection<String> names, TypeLiteral<T> typeLiteral) {
        return this.getValue(this.getConfigurationCoordinates(), names, typeLiteral == null ? (Type)null : typeLiteral.getType(), null);
    }

    public final <T> T getValue(Map<String, String> configurationCoordinates, Collection<String> names, Class<T> type, String defaultValue) {
        return this.getValue(configurationCoordinates, names, (Type)type, defaultValue);
    }

    public final <T> T getValue(Map<String, String> configurationCoordinates, Collection<String> names, TypeLiteral<T> typeLiteral, String defaultValue) {
        return this.getValue(configurationCoordinates, names, typeLiteral == null ? (Type)null : typeLiteral.getType(), defaultValue);
    }

    public final <T> T getValue(Map<String, String> configurationCoordinates, Collection<String> names, Type type, String defaultValue) {
        String cn = this.getClass().getName();
        Logger logger = Logger.getLogger(cn);
        String mn = "getValue";
        if (logger.isLoggable(Level.FINER)) {
            logger.entering(cn, "getValue", new Object[]{configurationCoordinates, names, type, defaultValue});
        }
        T returnValue = null;
        if (names == null || names.isEmpty()) {
            returnValue = this.getValue(configurationCoordinates, (String)null, type, defaultValue);
        } else {
            String name;
            Iterator<String> iterator = names.iterator();
            while (iterator.hasNext() && (returnValue = (T)this.getValue(configurationCoordinates, name = iterator.next(), type, null)) == null) {
            }
            if (returnValue == null) {
                iterator = names.iterator();
                while (iterator.hasNext() && (returnValue = (T)this.getValue(configurationCoordinates, name = iterator.next(), type, defaultValue)) == null) {
                }
            }
        }
        if (logger.isLoggable(Level.FINER)) {
            logger.exiting(cn, "getValue", returnValue);
        }
        return returnValue;
    }

    public abstract Set<String> getNames();

    public static final Configurations newInstance() {
        String cn = Configurations.class.getName();
        Logger logger = Logger.getLogger(cn);
        String mn = "newInstance";
        if (logger.isLoggable(Level.FINER)) {
            logger.entering(cn, "newInstance");
        }
        Configurations returnValue = null;
        ServiceLoader<Configurations> configurationsLoader = Configurations.configurationsLoader;
        if (configurationsLoader == null) {
            configurationsLoader = ServiceLoader.load(Configurations.class);
            assert (configurationsLoader != null);
            Configurations.configurationsLoader = configurationsLoader;
        }
        Iterator<Configurations> configurationsIterator = configurationsLoader.iterator();
        assert (configurationsIterator != null);
        while (returnValue == null && configurationsIterator.hasNext()) {
            try {
                returnValue = configurationsIterator.next();
            }
            catch (ServiceConfigurationError badServiceProviderFile) {
                throw new ConfigurationException(badServiceProviderFile);
            }
        }
        if (returnValue == null) {
            throw new ConfigurationException("No " + Configurations.class.getName() + " implementation found in any META-INF/services/" + Configurations.class.getName() + " service provider resources");
        }
        if (logger.isLoggable(Level.FINER)) {
            logger.exiting(cn, "newInstance", returnValue);
        }
        return returnValue;
    }
}

