/*
 * Decompiled with CFR 0.152.
 */
package org.microbean.configuration.api;

import java.io.Serializable;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Objects;

public abstract class TypeLiteral<T>
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final Class<?> classHierarchyParent;
    private transient Type type;

    protected TypeLiteral() {
        this(TypeLiteral.class);
    }

    protected <T extends TypeLiteral<?>> TypeLiteral(Class<T> classHierarchyParent) {
        Objects.requireNonNull(classHierarchyParent);
        this.classHierarchyParent = classHierarchyParent;
    }

    public final Type getType() {
        if (this.type == null) {
            Class<?> topmostTypeLiteralSubclass = TypeLiteral.getFirstSubclass(this.getClass(), this.classHierarchyParent);
            assert (topmostTypeLiteralSubclass != null);
            this.type = TypeLiteral.getSoleTypeParameter(topmostTypeLiteralSubclass);
            if (this.type == null) {
                throw new IllegalStateException("No type parameter specified");
            }
        }
        return this.type;
    }

    public int hashCode() {
        Type type = this.getType();
        return type == null ? 0 : type.hashCode();
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (other instanceof TypeLiteral) {
            TypeLiteral her = (TypeLiteral)other;
            Type type = this.getType();
            return !(type == null ? her.getType() != null : !type.equals(her.getType()));
        }
        return false;
    }

    public String toString() {
        return String.valueOf(this.getType());
    }

    private static final Class<?> getFirstSubclass(Class<?> c, Class<?> classHierarchyParentType) {
        Object returnValue;
        if (c == null || c.equals(Object.class)) {
            returnValue = null;
        } else {
            Class<?> superclass = c.getSuperclass();
            assert (superclass != null);
            returnValue = superclass.equals(classHierarchyParentType) ? c : (superclass.equals(Object.class) ? null : TypeLiteral.getFirstSubclass(superclass, classHierarchyParentType));
        }
        return returnValue;
    }

    private static final Type getSoleTypeParameter(Class<?> c) {
        ParameterizedType parameterizedType;
        Type[] actualTypeArguments;
        Type genericSuperclass;
        Type returnValue = null;
        if (c != null && (genericSuperclass = c.getGenericSuperclass()) instanceof ParameterizedType && (actualTypeArguments = (parameterizedType = (ParameterizedType)genericSuperclass).getActualTypeArguments()) != null && actualTypeArguments.length == 1) {
            returnValue = actualTypeArguments[0];
        }
        return returnValue;
    }
}

