/*
 * Decompiled with CFR 0.152.
 */
package org.microprofileext.config.source.etcd;

import com.coreos.jetcd.Client;
import com.coreos.jetcd.ClientBuilder;
import com.coreos.jetcd.data.ByteSequence;
import com.coreos.jetcd.data.KeyValue;
import com.coreos.jetcd.kv.GetResponse;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.microprofileext.config.source.base.EnabledConfigSource;

public class EtcdConfigSource
extends EnabledConfigSource {
    private static final Logger log = Logger.getLogger(EtcdConfigSource.class.getName());
    private static final String NAME = "EtcdConfigSource";
    private static final String KEY_PREFIX = "configsource.etcd.";
    private static final String KEY_SCHEME = "configsource.etcd.scheme";
    private static final String DEFAULT_SCHEME = "http";
    private static final String KEY_HOST = "configsource.etcd.host";
    private static final String DEFAULT_HOST = "localhost";
    private static final String KEY_PORT = "configsource.etcd.port";
    private static final Integer DEFAULT_PORT = 2379;
    private static final String KEY_USER = "configsource.etcd.user";
    private static final String KEY_PASSWORD = "configsource.etcd.password";
    private static final String KEY_AUTHORITY = "configsource.etcd.authority";
    private Client client = null;
    private static final String EMPTY = "";

    public EtcdConfigSource() {
        super.initOrdinal(320);
    }

    public Map<String, String> getPropertiesIfEnabled() {
        HashMap<String, String> m = new HashMap<String, String>();
        ByteSequence bsKey = ByteSequence.fromString((String)EMPTY);
        CompletableFuture getFuture = this.getClient().getKVClient().get(bsKey);
        try {
            GetResponse response = (GetResponse)getFuture.get();
            List kvs = response.getKvs();
            for (KeyValue kv : kvs) {
                String key = kv.getKey().toStringUtf8();
                String value = kv.getValue().toStringUtf8();
                m.put(key, value);
            }
        }
        catch (InterruptedException | ExecutionException ex) {
            log.log(Level.FINEST, "Can not get all config keys and values from etcd Config source: {1}", new Object[]{ex.getMessage()});
        }
        return m;
    }

    public String getValue(String key) {
        if (key.startsWith(KEY_PREFIX)) {
            return null;
        }
        if (super.isEnabled()) {
            ByteSequence bsKey = ByteSequence.fromString((String)key);
            CompletableFuture getFuture = this.getClient().getKVClient().get(bsKey);
            try {
                GetResponse response = (GetResponse)getFuture.get();
                String value = this.toString(response);
                return value;
            }
            catch (InterruptedException | ExecutionException ex) {
                log.log(Level.FINEST, "Can not get config value for [{0}] from etcd Config source: {1}", new Object[]{key, ex.getMessage()});
            }
        }
        return null;
    }

    public String getName() {
        return NAME;
    }

    private String toString(GetResponse response) {
        if (response.getCount() > 0L) {
            return ((KeyValue)response.getKvs().get(0)).getValue().toStringUtf8();
        }
        return null;
    }

    private Client getClient() {
        if (this.client == null) {
            log.info("Loading [etcd] MicroProfile ConfigSource");
            String scheme = this.getConfig().getOptionalValue(KEY_SCHEME, String.class).orElse(DEFAULT_SCHEME);
            String host = this.getConfig().getOptionalValue(KEY_HOST, String.class).orElse(DEFAULT_HOST);
            Integer port = this.getConfig().getOptionalValue(KEY_PORT, Integer.class).orElse(DEFAULT_PORT);
            String user = this.getConfig().getOptionalValue(KEY_USER, String.class).orElse(null);
            String password = this.getConfig().getOptionalValue(KEY_PASSWORD, String.class).orElse(null);
            String authority = this.getConfig().getOptionalValue(KEY_AUTHORITY, String.class).orElse(null);
            String endpoint = String.format("%s://%s:%d", scheme, host, port);
            log.log(Level.INFO, "Using [{0}] as etcd server endpoint", endpoint);
            ClientBuilder clientBuilder = Client.builder().endpoints(new String[]{endpoint});
            if (user != null) {
                ByteSequence bsUser = ByteSequence.fromString((String)user);
                clientBuilder = clientBuilder.user(bsUser);
            }
            if (password != null) {
                ByteSequence bsPassword = ByteSequence.fromString((String)password);
                clientBuilder = clientBuilder.password(bsPassword);
            }
            if (authority != null) {
                clientBuilder = clientBuilder.authority(authority);
            }
            this.client = clientBuilder.build();
        }
        return this.client;
    }
}

