/*
 * Decompiled with CFR 0.152.
 */
package org.microprofileext.config.source.xml;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import org.eclipse.microprofile.config.Config;
import org.microprofileext.config.source.base.file.AbstractUrlBasedSource;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class XmlConfigSource
extends AbstractUrlBasedSource {
    private static final Logger log = Logger.getLogger(XmlConfigSource.class.getName());
    private static final String COMMA = ",";

    protected String getFileExtension() {
        return "xml";
    }

    protected Map<String, String> toMap(InputStream inputStream) {
        try {
            InputSource inputSource = new InputSource(inputStream);
            return this.parse(inputSource);
        }
        catch (IOException | ParserConfigurationException | SAXException ex) {
            log.log(Level.WARNING, "Could not create properties from XML [{0}]", ex.getMessage());
            return new HashMap<String, String>();
        }
    }

    private Map<String, String> parse(InputSource inputSource) throws SAXException, IOException, ParserConfigurationException {
        Handler handler = new Handler(this.getConfig(), super.getKeySeparator());
        SAXParserFactory.newInstance().newSAXParser().parse(inputSource, (DefaultHandler)handler);
        return handler.result;
    }

    private String addToList(String existing, String newElement) {
        if (newElement.contains(COMMA)) {
            newElement = newElement.replaceAll(COMMA, "\\\\,");
        }
        String[] split = existing.split(COMMA);
        ArrayList<String> l = new ArrayList<String>(Arrays.asList(split));
        l.add(newElement);
        String join = String.join((CharSequence)COMMA, l);
        return join;
    }

    private class Handler
    extends DefaultHandler {
        private final StringBuilder valuebuffer = new StringBuilder();
        private final List<String> keybuffer = new LinkedList<String>();
        private final Map<String, String> result = new HashMap<String, String>();
        private final boolean ignoreRoot;
        private final String keySeparator;
        private int depth = -1;

        public Handler(Config cfg, String keySeparator) {
            this.ignoreRoot = cfg.getOptionalValue("configsource.xml.ignoreRoot", Boolean.class).orElse(true);
            this.keySeparator = keySeparator;
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            ++this.depth;
            if (this.depth != 0 || !this.ignoreRoot) {
                this.keybuffer.add(qName);
            }
        }

        @Override
        public void endElement(String uri, String localName, String qName) throws SAXException {
            String value = this.valuebuffer.toString().trim();
            String key = String.join((CharSequence)this.keySeparator, this.keybuffer);
            if (!value.isEmpty()) {
                if (this.result.containsKey(key)) {
                    this.result.put(key, XmlConfigSource.this.addToList(this.result.get(key), value));
                } else {
                    this.result.put(key, value.trim());
                }
            }
            this.valuebuffer.setLength(0);
            this.keybuffer.remove(qName);
            --this.depth;
        }

        @Override
        public void characters(char[] ch, int start, int length) throws SAXException {
            this.valuebuffer.append(ch, start, length);
        }
    }
}

