/*
 * Decompiled with CFR 0.152.
 */
package org.microprofileext.health.jvm;

import java.lang.management.ManagementFactory;
import java.lang.management.MemoryMXBean;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.eclipse.microprofile.config.inject.ConfigProperty;
import org.eclipse.microprofile.health.HealthCheck;
import org.eclipse.microprofile.health.HealthCheckResponse;
import org.eclipse.microprofile.health.HealthCheckResponseBuilder;
import org.eclipse.microprofile.health.Liveness;

@Liveness
@ApplicationScoped
public class NonHeapMemoryHealthCheck
implements HealthCheck {
    @Inject
    @ConfigProperty(name="health.jvm.memory.maxpercentage", defaultValue="0.9")
    double maxPercentage;

    public HealthCheckResponse call() {
        MemoryMXBean memoryBean = ManagementFactory.getMemoryMXBean();
        long memUsed = memoryBean.getNonHeapMemoryUsage().getUsed();
        long memMax = memoryBean.getNonHeapMemoryUsage().getMax();
        HealthCheckResponseBuilder responseBuilder = HealthCheckResponse.named((String)"non-heap-memory").withData("used", memUsed).withData("max", memMax).withData("max %", String.valueOf(this.maxPercentage));
        if (memMax > 0L) {
            boolean status = (double)memUsed < (double)memMax * this.maxPercentage;
            return responseBuilder.state(status).build();
        }
        return responseBuilder.up().build();
    }
}

