/*
 * Decompiled with CFR 0.152.
 */
package org.microprofileext.health.jvm;

import java.lang.management.ManagementFactory;
import java.lang.management.ThreadMXBean;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.eclipse.microprofile.config.inject.ConfigProperty;
import org.eclipse.microprofile.health.HealthCheck;
import org.eclipse.microprofile.health.HealthCheckResponse;
import org.eclipse.microprofile.health.HealthCheckResponseBuilder;
import org.eclipse.microprofile.health.Liveness;

@Liveness
@ApplicationScoped
public class ThreadHealthCheck
implements HealthCheck {
    @Inject
    @ConfigProperty(name="health.jvm.threadcount.max", defaultValue="-1")
    long maxThreadCount;

    public HealthCheckResponse call() {
        ThreadMXBean threadMXBean = ManagementFactory.getThreadMXBean();
        int threadCount = threadMXBean.getThreadCount();
        int peakThreadCount = threadMXBean.getPeakThreadCount();
        int daemonThreadCount = threadMXBean.getDaemonThreadCount();
        long totalStartedThreadCount = threadMXBean.getTotalStartedThreadCount();
        long[] deadlockedThreads = threadMXBean.findDeadlockedThreads();
        long[] monitorDeadlockedThreads = threadMXBean.findMonitorDeadlockedThreads();
        int deadlockedThreadCount = this.getNumberOfThreads(deadlockedThreads);
        int monitorDeadlockedThreadCount = this.getNumberOfThreads(monitorDeadlockedThreads);
        HealthCheckResponseBuilder responseBuilder = HealthCheckResponse.named((String)"threads").withData("thread count", (long)threadCount).withData("peak thread count", (long)peakThreadCount).withData("daemon thread count", (long)daemonThreadCount).withData("started thread count", totalStartedThreadCount).withData("deadlocked thread count", (long)deadlockedThreadCount).withData("monitor deadlocked thread count", (long)monitorDeadlockedThreadCount).withData("max thread count", this.maxThreadCount);
        if (threadCount > 0 && this.maxThreadCount > 0L) {
            boolean status = (long)threadCount < this.maxThreadCount;
            return responseBuilder.state(status).build();
        }
        return responseBuilder.up().build();
    }

    private int getNumberOfThreads(long[] ids) {
        if (ids == null) {
            return 0;
        }
        return ids.length;
    }
}

