/*
 * Decompiled with CFR 0.152.
 */
package org.microprofileext.openapi.example;

import java.util.Map;
import java.util.logging.Logger;
import javax.enterprise.context.RequestScoped;
import javax.inject.Inject;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.eclipse.microprofile.openapi.annotations.Operation;
import org.eclipse.microprofile.openapi.annotations.parameters.Parameter;
import org.eclipse.microprofile.openapi.annotations.responses.APIResponse;
import org.eclipse.microprofile.openapi.annotations.tags.Tag;
import org.microprofileext.openapi.example.Person;

@RequestScoped
@Path(value="/")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
@Tag(name="Person service", description="Just some example")
public class PersonService {
    private static final Logger log = Logger.getLogger(PersonService.class.getName());
    @Inject
    private Map<Integer, Person> people;

    @GET
    @Path(value="/all")
    @Produces(value={"application/json"})
    @Operation(operationId="all", description="Getting all people")
    @APIResponse(responseCode="200", description="Successful, returning the map in JSON format")
    public Response getAll() {
        return Response.ok((Object)this.people).build();
    }

    @GET
    @Path(value="/id/{id}")
    @Operation(operationId="value", description="Getting the person by id")
    @APIResponse(responseCode="200", description="Successful, returning the person")
    @Produces(value={"application/json"})
    public Response getPerson(@Parameter(name="id", description="The id for the person", required=true, allowEmptyValue=false, example="1") @PathParam(value="id") Integer id) {
        if (this.people.containsKey(id)) {
            Person p = (Person)this.people.get(id);
            return Response.ok((Object)p).build();
        }
        return Response.noContent().build();
    }
}

