/*
 * Decompiled with CFR 0.152.
 */
package org.milyn.ejc.maven;

import java.io.File;
import org.apache.maven.model.Resource;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;
import org.jfrog.maven.annomojo.annotations.MojoGoal;
import org.jfrog.maven.annomojo.annotations.MojoParameter;
import org.jfrog.maven.annomojo.annotations.MojoPhase;
import org.jfrog.maven.annomojo.annotations.MojoRequiresDependencyResolution;
import org.milyn.ejc.EJCException;
import org.milyn.ejc.EJCExecutor;

@MojoGoal(value="generate")
@MojoPhase(value="generate-sources")
@MojoRequiresDependencyResolution
public class EJCMojo
extends AbstractMojo {
    @MojoParameter(expression="${project}", required=true, readonly=true)
    private MavenProject project;
    @MojoParameter(expression="target/ejc", required=false)
    private File destDir;
    @MojoParameter(expression="src/main/resources/edi-model.xml", required=false)
    private File ediMappingFile;
    @MojoParameter(required=true)
    private String packageName;

    public void execute() throws MojoExecutionException {
        EJCExecutor ejc = new EJCExecutor();
        if (this.ediMappingFile.exists()) {
            try {
                ejc.setDestDir(this.destDir);
                ejc.setEdiMappingModel(this.ediMappingFile);
                ejc.setPackageName(this.packageName);
                if (this.destDir.exists()) {
                    this.destDir.delete();
                }
                ejc.execute();
                this.project.addCompileSourceRoot(this.destDir.getPath());
                Resource resource = new Resource();
                resource.setDirectory(this.destDir.getPath());
                resource.addInclude("**/*.xml");
                this.project.addResource(resource);
            }
            catch (EJCException e) {
                throw new MojoExecutionException("Error Executing EJC Maven Plugin.  See chained cause.", (Exception)((Object)e));
            }
        } else {
            throw new MojoExecutionException("EDI mapping model '" + this.ediMappingFile.getAbsolutePath() + "' not found.");
        }
    }
}

