/*
 * Decompiled with CFR 0.152.
 */
package org.minbox.framework.api.boot.autoconfigure.datasource;

import java.util.HashMap;
import java.util.LinkedList;
import javax.sql.DataSource;
import org.minbox.framework.api.boot.autoconfigure.datasource.ApiBootDataSourceSwitchProperties;
import org.minbox.framework.api.boot.plugin.datasource.ApiBootDataSource;
import org.minbox.framework.api.boot.plugin.datasource.ApiBootDataSourceFactoryBean;
import org.minbox.framework.api.boot.plugin.datasource.aop.advistor.ApiBootDataSourceSwitchAdvisor;
import org.minbox.framework.api.boot.plugin.datasource.aop.interceptor.ApiBootDataSourceSwitchAnnotationInterceptor;
import org.minbox.framework.api.boot.plugin.datasource.config.DataSourceConfig;
import org.minbox.framework.api.boot.plugin.datasource.config.DataSourceDruidConfig;
import org.minbox.framework.api.boot.plugin.datasource.routing.ApiBootRoutingDataSource;
import org.minbox.framework.api.boot.plugin.datasource.support.ApiBootDruidDataSource;
import org.minbox.framework.api.boot.plugin.datasource.support.ApiBootHikariDataSource;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.jdbc.DataSourceAutoConfiguration;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConditionalOnClass(value={ApiBootDataSource.class})
@EnableConfigurationProperties(value={ApiBootDataSourceSwitchProperties.class})
@AutoConfigureBefore(value={DataSourceAutoConfiguration.class})
public class ApiBootDataSourceSwitchAutoConfiguration {
    private ApiBootDataSourceSwitchProperties apiBootDataSourceSwitchProperties;

    public ApiBootDataSourceSwitchAutoConfiguration(ApiBootDataSourceSwitchProperties apiBootDataSourceSwitchProperties) {
        this.apiBootDataSourceSwitchProperties = apiBootDataSourceSwitchProperties;
    }

    @Bean
    @ConditionalOnMissingBean
    public ApiBootDataSourceFactoryBean apiBootDataSourceFactoryBean() {
        return new ApiBootDataSourceFactoryBean();
    }

    @Bean
    @ConditionalOnMissingBean
    public DataSource dataSource(ApiBootDataSourceFactoryBean apiBootDataSourceFactoryBean) {
        LinkedList dataSourceConfigList = new LinkedList();
        HashMap<String, Object> dataSourceConfigMap = new HashMap<String, Object>(1);
        dataSourceConfigMap.putAll(this.apiBootDataSourceSwitchProperties.getDruid());
        dataSourceConfigMap.putAll(this.apiBootDataSourceSwitchProperties.getHikari());
        dataSourceConfigMap.keySet().stream().forEach(poolName -> {
            DataSourceConfig dataSourceConfig = (DataSourceConfig)dataSourceConfigMap.get(poolName);
            dataSourceConfig.setPoolName(poolName);
            dataSourceConfig.setDataSourceType(dataSourceConfig instanceof DataSourceDruidConfig ? ApiBootDruidDataSource.class : ApiBootHikariDataSource.class);
            dataSourceConfigList.add(dataSourceConfig);
        });
        return new ApiBootRoutingDataSource(apiBootDataSourceFactoryBean, this.apiBootDataSourceSwitchProperties.getPrimary(), dataSourceConfigList);
    }

    @Bean
    @ConditionalOnMissingBean
    public ApiBootDataSourceSwitchAnnotationInterceptor apiBootDataSourceSwitchAnnotationInterceptor() {
        return new ApiBootDataSourceSwitchAnnotationInterceptor();
    }

    @Bean
    @ConditionalOnMissingBean
    public ApiBootDataSourceSwitchAdvisor apiBootDataSourceSwitchAdvisor(ApiBootDataSourceSwitchAnnotationInterceptor apiBootDataSourceSwitchAnnotationInterceptor) {
        return new ApiBootDataSourceSwitchAdvisor(apiBootDataSourceSwitchAnnotationInterceptor);
    }
}

