/*
 * Decompiled with CFR 0.152.
 */
package org.minbox.framework.api.boot.autoconfigure.logging;

import org.minbox.framework.api.boot.autoconfigure.logging.ApiBootLoggingProperties;
import org.minbox.framework.logging.client.admin.discovery.LoggingAdminDiscovery;
import org.minbox.framework.logging.client.admin.discovery.support.LoggingRegistryCenterAdminDiscovery;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.client.loadbalancer.LoadBalancerClient;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.util.ObjectUtils;

@Configuration
@ConditionalOnClass(value={LoadBalancerClient.class})
@EnableConfigurationProperties(value={ApiBootLoggingProperties.class})
@ConditionalOnProperty(prefix="api.boot.logging", name={"discovery.service-id"})
public class ApiBootLoggingAdminDiscoveryAutoConfiguration {
    private ApiBootLoggingProperties apiBootLoggingProperties;

    public ApiBootLoggingAdminDiscoveryAutoConfiguration(ApiBootLoggingProperties apiBootLoggingProperties) {
        this.apiBootLoggingProperties = apiBootLoggingProperties;
    }

    @Bean
    @ConditionalOnMissingBean
    public LoggingAdminDiscovery loggingRegistryCenterAdminDiscovery(LoadBalancerClient loadBalancerClient) {
        String basicAuthPassword;
        LoggingRegistryCenterAdminDiscovery registryCenterAdminDiscovery = new LoggingRegistryCenterAdminDiscovery(this.apiBootLoggingProperties.getDiscovery().getServiceId(), loadBalancerClient);
        String basicAuthUserName = this.apiBootLoggingProperties.getDiscovery().getUsername();
        if (!ObjectUtils.isEmpty((Object)basicAuthUserName)) {
            registryCenterAdminDiscovery.setUsername(basicAuthUserName);
        }
        if (!ObjectUtils.isEmpty((Object)(basicAuthPassword = this.apiBootLoggingProperties.getDiscovery().getPassword()))) {
            registryCenterAdminDiscovery.setPassword(basicAuthPassword);
        }
        return registryCenterAdminDiscovery;
    }
}

