/*
 * Decompiled with CFR 0.152.
 */
package org.minbox.framework.api.boot.autoconfigure.logging.admin;

import javax.sql.DataSource;
import org.minbox.framework.api.boot.autoconfigure.logging.admin.ApiBootLoggingAdminProperties;
import org.minbox.framework.api.boot.autoconfigure.logging.admin.ui.ApiBootLoggingAdminUiAutoConfiguration;
import org.minbox.framework.logging.admin.LoggingAdminFactoryBean;
import org.minbox.framework.logging.admin.storage.LoggingDataSourceStorage;
import org.minbox.framework.logging.admin.storage.LoggingStorage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.BeanCreationException;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.jdbc.DataSourceAutoConfiguration;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.scheduling.annotation.EnableAsync;

@Configuration
@ConditionalOnClass(value={LoggingAdminFactoryBean.class})
@ConditionalOnBean(value={DataSource.class})
@EnableConfigurationProperties(value={ApiBootLoggingAdminProperties.class})
@AutoConfigureAfter(value={DataSourceAutoConfiguration.class})
@Import(value={ApiBootLoggingAdminUiAutoConfiguration.class})
@EnableAsync
public class ApiBootLoggingAdminAutoConfiguration {
    static Logger logger = LoggerFactory.getLogger(ApiBootLoggingAdminAutoConfiguration.class);
    private ApiBootLoggingAdminProperties apiBootLoggingAdminProperties;

    public ApiBootLoggingAdminAutoConfiguration(ApiBootLoggingAdminProperties apiBootLoggingAdminProperties) {
        this.apiBootLoggingAdminProperties = apiBootLoggingAdminProperties;
    }

    @Bean
    @ConditionalOnMissingBean
    public LoggingDataSourceStorage loggingDataSourceStorage(DataSource dataSource) {
        LoggingDataSourceStorage storage = new LoggingDataSourceStorage(dataSource);
        return storage;
    }

    @Bean
    @ConditionalOnMissingBean
    public LoggingAdminFactoryBean loggingAdminFactoryBean(LoggingDataSourceStorage loggingDataSourceStorage) {
        LoggingAdminFactoryBean factoryBean = new LoggingAdminFactoryBean();
        factoryBean.setLoggingStorage((LoggingStorage)loggingDataSourceStorage);
        factoryBean.setShowConsoleReportLog(this.apiBootLoggingAdminProperties.isShowConsoleReportLog());
        factoryBean.setFormatConsoleLogJson(this.apiBootLoggingAdminProperties.isFormatConsoleLogJson());
        logger.info("\u3010LoggingAdminFactoryBean\u3011init successfully.");
        return factoryBean;
    }

    @Configuration
    @ConditionalOnMissingBean(value={DataSource.class})
    public static class DataSourceNotFoundConfiguration
    implements InitializingBean {
        public void afterPropertiesSet() throws Exception {
            throw new BeanCreationException("No " + DataSource.class.getName() + " Found.");
        }
    }
}

