/*
 * Decompiled with CFR 0.152.
 */
package org.minbox.framework.api.boot.autoconfigure.oauth;

import java.util.List;
import org.minbox.framework.api.boot.autoconfigure.oauth.ApiBootOauthProperties;
import org.minbox.framework.api.boot.plugin.oauth.ApiBootAuthorizationServerConfiguration;
import org.minbox.framework.api.boot.plugin.oauth.grant.ApiBootOauthTokenGranter;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.security.oauth2.provider.token.AccessTokenConverter;
import org.springframework.security.oauth2.provider.token.DefaultAccessTokenConverter;
import org.springframework.security.oauth2.provider.token.store.JwtAccessTokenConverter;

public class ApiBootAuthorizationServerAutoConfiguration
extends ApiBootAuthorizationServerConfiguration {
    protected ApiBootOauthProperties apiBootOauthProperties;

    public ApiBootAuthorizationServerAutoConfiguration(ObjectProvider<List<ApiBootOauthTokenGranter>> objectProvider, ApiBootOauthProperties apiBootOauthProperties) {
        super(objectProvider);
        this.apiBootOauthProperties = apiBootOauthProperties;
    }

    @Bean
    @ConditionalOnProperty(prefix="api.boot.oauth", name={"jwt.enable"}, havingValue="true")
    public AccessTokenConverter jwtAccessTokenConverter() {
        JwtAccessTokenConverter converter = new JwtAccessTokenConverter();
        converter.setSigningKey(this.apiBootOauthProperties.getJwt().getSignKey());
        return converter;
    }

    @Bean
    @ConditionalOnProperty(prefix="api.boot.oauth", name={"jwt.enable"}, havingValue="false", matchIfMissing=true)
    public AccessTokenConverter defaultAccessTokenConverter() {
        return new DefaultAccessTokenConverter();
    }
}

