/*
 * Decompiled with CFR 0.152.
 */
package org.minbox.framework.api.boot.autoconfigure.oauth;

import java.util.List;
import org.minbox.framework.api.boot.autoconfigure.oauth.ApiBootAuthorizationServerAutoConfiguration;
import org.minbox.framework.api.boot.autoconfigure.oauth.ApiBootOauthProperties;
import org.minbox.framework.api.boot.plugin.oauth.ApiBootAuthorizationServerConfiguration;
import org.minbox.framework.api.boot.plugin.oauth.grant.ApiBootOauthTokenGranter;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.data.redis.RedisAutoConfiguration;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.redis.connection.RedisConnectionFactory;
import org.springframework.security.oauth2.config.annotation.builders.InMemoryClientDetailsServiceBuilder;
import org.springframework.security.oauth2.config.annotation.configurers.ClientDetailsServiceConfigurer;
import org.springframework.security.oauth2.config.annotation.web.configuration.EnableAuthorizationServer;
import org.springframework.security.oauth2.provider.token.TokenStore;
import org.springframework.security.oauth2.provider.token.store.redis.RedisTokenStore;

@Configuration
@EnableConfigurationProperties(value={ApiBootOauthProperties.class})
@EnableAuthorizationServer
@ConditionalOnBean(value={RedisConnectionFactory.class})
@ConditionalOnClass(value={ApiBootAuthorizationServerConfiguration.class})
@ConditionalOnProperty(prefix="api.boot.oauth", name={"away"}, havingValue="redis")
@AutoConfigureAfter(value={RedisAutoConfiguration.class})
public class ApiBootAuthorizationServerRedisAutoConfiguration
extends ApiBootAuthorizationServerAutoConfiguration {
    private RedisConnectionFactory redisConnectionFactory;

    public ApiBootAuthorizationServerRedisAutoConfiguration(ObjectProvider<List<ApiBootOauthTokenGranter>> objectProvider, ApiBootOauthProperties apiBootOauthProperties, RedisConnectionFactory redisConnectionFactory) {
        super(objectProvider, apiBootOauthProperties);
        this.redisConnectionFactory = redisConnectionFactory;
    }

    public void configure(ClientDetailsServiceConfigurer clients) throws Exception {
        InMemoryClientDetailsServiceBuilder inMemoryClientDetailsServiceBuilder = clients.inMemory();
        this.apiBootOauthProperties.getClients().stream().forEach(client -> inMemoryClientDetailsServiceBuilder.withClient(client.getClientId()).secret(this.passwordEncoder().encode((CharSequence)client.getClientSecret())).authorizedGrantTypes(client.getGrantTypes()).scopes(client.getScopes()).resourceIds(client.getResourceId()).accessTokenValiditySeconds(client.getAccessTokenValiditySeconds()));
    }

    @Bean
    public TokenStore redisTokenStore() {
        return new RedisTokenStore(this.redisConnectionFactory);
    }
}

