/*
 * Decompiled with CFR 0.152.
 */
package org.minbox.framework.api.boot.autoconfigure.pageable;

import com.gitee.hengboy.mybatis.pageable.config.PageableConfigurer;
import com.gitee.hengboy.mybatis.pageable.interceptor.MyBatisExecutePageableInterceptor;
import java.util.List;
import javax.annotation.PostConstruct;
import org.apache.ibatis.plugin.Interceptor;
import org.apache.ibatis.session.SqlSessionFactory;
import org.minbox.framework.api.boot.autoconfigure.pageable.ApiBootMyBatisPageableProperties;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.jdbc.DataSourceAutoConfiguration;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConditionalOnBean(value={SqlSessionFactory.class})
@EnableConfigurationProperties(value={ApiBootMyBatisPageableProperties.class})
@ConditionalOnClass(value={MyBatisExecutePageableInterceptor.class})
@AutoConfigureAfter(value={DataSourceAutoConfiguration.class})
public class ApiBootMybatisPageableAutoConfiguration {
    private ApiBootMyBatisPageableProperties myBatisPageableProperties;
    private List<SqlSessionFactory> sqlSessionFactoryList;
    private PageableConfigurer pageableConfigurer;

    public ApiBootMybatisPageableAutoConfiguration(ApiBootMyBatisPageableProperties myBatisPageableProperties, ObjectProvider<List<SqlSessionFactory>> interceptorsProvider, ObjectProvider<PageableConfigurer> pageableConfigurerObjectProvider) {
        this.myBatisPageableProperties = myBatisPageableProperties;
        this.sqlSessionFactoryList = (List)interceptorsProvider.getIfAvailable();
        this.pageableConfigurer = (PageableConfigurer)pageableConfigurerObjectProvider.getIfAvailable();
    }

    @PostConstruct
    void addInterceptors() {
        MyBatisExecutePageableInterceptor interceptor = new MyBatisExecutePageableInterceptor();
        interceptor.setProperties(this.myBatisPageableProperties.getProperties());
        for (SqlSessionFactory sqlSessionFactory : this.sqlSessionFactoryList) {
            this.addPreInterceptors(sqlSessionFactory);
            sqlSessionFactory.getConfiguration().addInterceptor((Interceptor)interceptor);
            this.addPostInterceptors(sqlSessionFactory);
        }
    }

    void addPreInterceptors(SqlSessionFactory sqlSessionFactory) {
        if (this.allowPageableConfigurer() && this.pageableConfigurer.prePlugins() != null) {
            this.loopAddInterceptor(this.pageableConfigurer.prePlugins(), sqlSessionFactory);
        }
    }

    void addPostInterceptors(SqlSessionFactory sqlSessionFactory) {
        if (this.allowPageableConfigurer() && this.pageableConfigurer.postPlugins() != null) {
            this.loopAddInterceptor(this.pageableConfigurer.postPlugins(), sqlSessionFactory);
        }
    }

    void loopAddInterceptor(List<Interceptor> interceptors, SqlSessionFactory sqlSessionFactory) {
        for (Interceptor interceptor : interceptors) {
            sqlSessionFactory.getConfiguration().addInterceptor(interceptor);
        }
    }

    boolean allowPageableConfigurer() {
        return this.pageableConfigurer != null;
    }
}

