/*
 * Decompiled with CFR 0.152.
 */
package org.minbox.framework.api.boot.autoconfigure.resource;

import org.minbox.framework.api.boot.autoconfigure.resource.ApiBootResourceRedisLoadAutoConfiguration;
import org.minbox.framework.api.boot.plugin.resource.load.ApiBootResourceStoreDelegate;
import org.minbox.framework.api.boot.plugin.resource.load.aop.advistor.ApiBootResourceLoadAdvisor;
import org.minbox.framework.api.boot.plugin.resource.load.aop.interceptor.ApiBootResourceLoadMethodInterceptor;
import org.minbox.framework.api.boot.plugin.resource.load.pusher.ApiBootResourcePusher;
import org.minbox.framework.api.boot.plugin.resource.load.pusher.support.ApiBootMemoryResourcePusher;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingClass;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;

@Configuration
@ConditionalOnClass(value={ApiBootResourceStoreDelegate.class})
@Import(value={ApiBootResourceRedisLoadAutoConfiguration.class})
public class ApiBootResourceLoadAutoConfiguration {
    private ApiBootResourceStoreDelegate resourceStoreDelegate;

    public ApiBootResourceLoadAutoConfiguration(ObjectProvider<ApiBootResourceStoreDelegate> resourceStoreDelegateObjectProvider) {
        this.resourceStoreDelegate = (ApiBootResourceStoreDelegate)resourceStoreDelegateObjectProvider.getIfAvailable();
    }

    @Bean
    @ConditionalOnMissingBean
    ApiBootResourceLoadAdvisor resourceLoadAdvisor(ApiBootResourceLoadMethodInterceptor resourceLoadMethodInterceptor) {
        return new ApiBootResourceLoadAdvisor(resourceLoadMethodInterceptor);
    }

    @Bean
    @ConditionalOnMissingBean
    ApiBootResourceLoadMethodInterceptor resourceLoadMethodInterceptor(ApiBootResourcePusher apiBootResourcePusher) {
        return new ApiBootResourceLoadMethodInterceptor(apiBootResourcePusher);
    }

    @Bean
    @ConditionalOnMissingBean
    @ConditionalOnMissingClass(value={"org.springframework.data.redis.core.RedisTemplate"})
    ApiBootMemoryResourcePusher apiBootMemoryResourcePusher() {
        return new ApiBootMemoryResourcePusher(this.resourceStoreDelegate);
    }
}

