/*
 * Decompiled with CFR 0.152.
 */
package org.minbox.framework.api.boot.autoconfigure.security;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.minbox.framework.api.boot.autoconfigure.security.ApiBootSecurityProperties;
import org.minbox.framework.api.boot.plugin.security.ApiBootWebSecurityConfiguration;
import org.minbox.framework.api.boot.plugin.security.handler.ApiBootDefaultAccessDeniedHandler;
import org.minbox.framework.api.boot.plugin.security.point.ApiBootDefaultAuthenticationEntryPoint;
import org.springframework.security.web.AuthenticationEntryPoint;
import org.springframework.security.web.access.AccessDeniedHandler;
import org.springframework.util.ObjectUtils;

public class ApiBootWebSecurityAutoConfiguration
extends ApiBootWebSecurityConfiguration {
    protected ApiBootSecurityProperties apiBootSecurityProperties;
    private AccessDeniedHandler accessDeniedHandler;
    private AuthenticationEntryPoint authenticationEntryPoint;

    public ApiBootWebSecurityAutoConfiguration(ApiBootSecurityProperties apiBootSecurityProperties, AccessDeniedHandler accessDeniedHandler, AuthenticationEntryPoint authenticationEntryPoint) {
        this.apiBootSecurityProperties = apiBootSecurityProperties;
        this.accessDeniedHandler = accessDeniedHandler;
        this.authenticationEntryPoint = authenticationEntryPoint;
    }

    protected List<String> configureIgnoreUrls() {
        ArrayList<String> ignoringUrls = new ArrayList<String>();
        ignoringUrls.addAll(Arrays.asList(ApiBootSecurityProperties.DEFAULT_IGNORE_URLS));
        if (!ObjectUtils.isEmpty((Object[])this.apiBootSecurityProperties.getIgnoringUrls())) {
            ignoringUrls.addAll(Arrays.asList(this.apiBootSecurityProperties.getIgnoringUrls()));
        }
        return ignoringUrls;
    }

    protected AccessDeniedHandler getAccessDeniedHandler() {
        return ObjectUtils.isEmpty((Object)this.accessDeniedHandler) ? new ApiBootDefaultAccessDeniedHandler() : this.accessDeniedHandler;
    }

    protected AuthenticationEntryPoint getAuthenticationEntryPoint() {
        return ObjectUtils.isEmpty((Object)this.authenticationEntryPoint) ? new ApiBootDefaultAuthenticationEntryPoint() : this.authenticationEntryPoint;
    }

    protected boolean disableHttpBasic() {
        return this.apiBootSecurityProperties.isDisableHttpBasic();
    }

    protected boolean disableCsrf() {
        return this.apiBootSecurityProperties.isDisableCsrf();
    }
}

