/*
 * Decompiled with CFR 0.152.
 */
package org.minbox.framework.api.boot.autoconfigure.converter;

import com.alibaba.fastjson.serializer.SerializeFilter;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.alibaba.fastjson.serializer.ValueFilter;
import com.alibaba.fastjson.support.config.FastJsonConfig;
import com.alibaba.fastjson.support.spring.FastJsonHttpMessageConverter;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import org.minbox.framework.api.boot.common.tools.ClassTools;
import org.reflections.util.ConfigurationBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.AutoConfigurationPackages;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.http.HttpMessageConverters;
import org.springframework.boot.autoconfigure.http.HttpMessageConvertersAutoConfiguration;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.util.ObjectUtils;

@Configuration
@ConditionalOnClass(value={FastJsonHttpMessageConverter.class, ConfigurationBuilder.class})
@AutoConfigureBefore(value={HttpMessageConvertersAutoConfiguration.class})
@ConditionalOnProperty(prefix="spring.mvc.converters", value={"preferred-json-mapper"}, havingValue="fastJson", matchIfMissing=true)
public class HttpMessageConverterAutoConfiguration {
    static Logger logger = LoggerFactory.getLogger(HttpMessageConverterAutoConfiguration.class);
    private static final String[] VALUE_FILTER_PACKAGE = new String[]{"org.minbox.framework.api.boot.plugin.http.converter.filter"};
    @Autowired
    private BeanFactory beanFactory;

    @Bean
    @ConditionalOnMissingBean
    HttpMessageConverters fastJsonHttpMessageConverters() {
        FastJsonHttpMessageConverter fastConverter = new FastJsonHttpMessageConverter();
        FastJsonConfig fastJsonConfig = new FastJsonConfig();
        fastJsonConfig.setSerializerFeatures(new SerializerFeature[]{SerializerFeature.DisableCircularReferenceDetect, SerializerFeature.WriteMapNullValue, SerializerFeature.WriteNullListAsEmpty, SerializerFeature.WriteNullStringAsEmpty, SerializerFeature.WriteNullNumberAsZero, SerializerFeature.WriteDateUseDateFormat, SerializerFeature.WriteNullBooleanAsFalse});
        List packages = AutoConfigurationPackages.get((BeanFactory)this.beanFactory);
        packages.addAll(Arrays.asList(VALUE_FILTER_PACKAGE));
        fastJsonConfig.setSerializeFilters((SerializeFilter[])this.getDefineFilters(packages));
        fastConverter.setFastJsonConfig(fastJsonConfig);
        return new HttpMessageConverters(new HttpMessageConverter[]{fastConverter});
    }

    ValueFilter[] getDefineFilters(List<String> packages) {
        HashSet filterClass = new HashSet();
        if (ObjectUtils.isEmpty(packages)) {
            return new ValueFilter[0];
        }
        packages.stream().forEach(pack -> filterClass.addAll(ClassTools.getSubClassList((String)pack, ValueFilter.class)));
        LinkedList filters = new LinkedList();
        filterClass.stream().forEach(filter -> {
            try {
                filters.add((ValueFilter)filter.newInstance());
            }
            catch (Exception e) {
                logger.error("ValueFilter new instance have error.", (Throwable)e);
            }
        });
        logger.info("Loaded ValueFilter : {}", (Object)((Object)filterClass).toString());
        return filters.toArray(new ValueFilter[0]);
    }
}

