/*
 * Decompiled with CFR 0.152.
 */
package org.minbox.framework.api.boot.autoconfigure.datasource;

import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import javax.sql.DataSource;
import org.minbox.framework.api.boot.autoconfigure.datasource.ApiBootDataSourceSwitchEnvironmentProperties;
import org.minbox.framework.api.boot.autoconfigure.datasource.ApiBootDataSourceSwitchProperties;
import org.minbox.framework.datasource.DataSourceFactoryBean;
import org.minbox.framework.datasource.MinBoxDataSource;
import org.minbox.framework.datasource.aop.advistor.DataSourceSwitchAdvisor;
import org.minbox.framework.datasource.aop.interceptor.DataSourceSwitchAnnotationInterceptor;
import org.minbox.framework.datasource.config.DataSourceConfig;
import org.minbox.framework.datasource.config.DataSourceDruidConfig;
import org.minbox.framework.datasource.environment.DataSourceSwitchEnvironment;
import org.minbox.framework.datasource.environment.customizer.DataSourceEnvironmentSelectionCustomizer;
import org.minbox.framework.datasource.routing.MinBoxSwitchRoutingDataSource;
import org.minbox.framework.datasource.support.MinBoxDruidDataSource;
import org.minbox.framework.datasource.support.MinBoxHikariDataSource;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.jdbc.DataSourceAutoConfiguration;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.jdbc.datasource.lookup.AbstractRoutingDataSource;

@Configuration
@ConditionalOnClass(value={MinBoxDataSource.class, AbstractRoutingDataSource.class})
@EnableConfigurationProperties(value={ApiBootDataSourceSwitchProperties.class})
@AutoConfigureBefore(value={DataSourceAutoConfiguration.class})
public class ApiBootDataSourceSwitchAutoConfiguration {
    private ApiBootDataSourceSwitchProperties dataSourceSwitchProperties;
    private DataSourceEnvironmentSelectionCustomizer environmentSelectionCustomizer;

    public ApiBootDataSourceSwitchAutoConfiguration(ApiBootDataSourceSwitchProperties dataSourceSwitchProperties, ObjectProvider<DataSourceEnvironmentSelectionCustomizer> customizerObjectProvider) {
        this.dataSourceSwitchProperties = dataSourceSwitchProperties;
        this.environmentSelectionCustomizer = (DataSourceEnvironmentSelectionCustomizer)customizerObjectProvider.getIfAvailable();
    }

    @Bean
    @ConditionalOnMissingBean
    public DataSourceFactoryBean dataSourceFactoryBean() {
        return new DataSourceFactoryBean();
    }

    @Bean
    @ConditionalOnMissingBean
    public DataSource dataSource(DataSourceFactoryBean dataSourceFactoryBean) {
        List switchEnvironments = this.dataSourceSwitchProperties.getEnvironments().keySet().stream().map(environment -> {
            ApiBootDataSourceSwitchEnvironmentProperties environmentProperties = this.dataSourceSwitchProperties.getEnvironments().get(environment);
            HashMap<String, Object> dataSourceConfigMap = new HashMap<String, Object>();
            dataSourceConfigMap.putAll(environmentProperties.getDruid());
            dataSourceConfigMap.putAll(environmentProperties.getHikari());
            List configs = dataSourceConfigMap.keySet().stream().map(poolName -> {
                DataSourceConfig dataSourceConfig = (DataSourceConfig)dataSourceConfigMap.get(poolName);
                dataSourceConfig.setPoolName(poolName);
                dataSourceConfig.setDataSourceType(dataSourceConfig instanceof DataSourceDruidConfig ? MinBoxDruidDataSource.class : MinBoxHikariDataSource.class);
                return dataSourceConfig;
            }).collect(Collectors.toList());
            return DataSourceSwitchEnvironment.initialization().environment(environment).primaryPoolName(environmentProperties.getPrimary()).configs(configs).build();
        }).collect(Collectors.toList());
        return new MinBoxSwitchRoutingDataSource(dataSourceFactoryBean, this.environmentSelectionCustomizer, this.dataSourceSwitchProperties.getActiveEnvironment(), switchEnvironments);
    }

    @Bean
    @ConditionalOnMissingBean
    public DataSourceSwitchAnnotationInterceptor dataSourceSwitchAnnotationInterceptor() {
        return new DataSourceSwitchAnnotationInterceptor();
    }

    @Bean
    @ConditionalOnMissingBean
    public DataSourceSwitchAdvisor apiBootDataSourceSwitchAdvisor(DataSourceSwitchAnnotationInterceptor dataSourceSwitchAnnotationInterceptor) {
        return new DataSourceSwitchAdvisor(dataSourceSwitchAnnotationInterceptor);
    }
}

