/*
 * Decompiled with CFR 0.152.
 */
package org.minbox.framework.api.boot.autoconfigure.grace;

import java.util.List;
import org.minbox.framework.api.boot.autoconfigure.grace.ApiBootGraceLogProperties;
import org.minbox.framework.grace.core.GraceRecorderAopBeanDefinitionRegistrar;
import org.minbox.framework.grace.core.operator.GraceLoadOperatorService;
import org.minbox.framework.grace.expression.ExpressionFunctionFactory;
import org.minbox.framework.grace.processor.GraceLogStorageProcessor;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.boot.autoconfigure.AutoConfigurationPackages;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.context.annotation.Primary;
import org.springframework.util.ObjectUtils;

@Configuration
@ConditionalOnClass(value={ExpressionFunctionFactory.class, GraceLogStorageProcessor.class, GraceLoadOperatorService.class})
@Import(value={GraceRecorderAopBeanDefinitionRegistrar.class})
@EnableConfigurationProperties(value={ApiBootGraceLogProperties.class})
public class ApiBootGraceLogAutoConfiguration {
    private BeanFactory beanFactory;
    private ApiBootGraceLogProperties graceLogProperties;

    public ApiBootGraceLogAutoConfiguration(BeanFactory beanFactory, ApiBootGraceLogProperties graceLogProperties) {
        this.beanFactory = beanFactory;
        this.graceLogProperties = graceLogProperties;
    }

    @Bean
    @Primary
    public ExpressionFunctionFactory expressionFunctionFactory() {
        List basePackageList = this.graceLogProperties.getFunctionScanBasePackages();
        if (ObjectUtils.isEmpty(basePackageList)) {
            basePackageList = AutoConfigurationPackages.get((BeanFactory)this.beanFactory);
        }
        return new ExpressionFunctionFactory(basePackageList);
    }
}

