/*
 * Decompiled with CFR 0.152.
 */
package org.minbox.framework.api.boot.autoconfigure.logging;

import org.minbox.framework.api.boot.autoconfigure.logging.ApiBootLoggingProperties;
import org.minbox.framework.api.boot.autoconfigure.logging.LoadBalanceStrategyAway;
import org.minbox.framework.logging.client.admin.discovery.LoggingAdminDiscovery;
import org.minbox.framework.logging.client.admin.discovery.lb.LoadBalanceStrategy;
import org.minbox.framework.logging.client.admin.discovery.lb.support.RandomWeightedStrategy;
import org.minbox.framework.logging.client.admin.discovery.lb.support.SmoothWeightedRoundRobinStrategy;
import org.minbox.framework.logging.client.admin.discovery.support.LoggingAppointAdminDiscovery;
import org.minbox.framework.logging.client.admin.discovery.support.LoggingRegistryCenterAdminDiscovery;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@EnableConfigurationProperties(value={ApiBootLoggingProperties.class})
@ConditionalOnMissingBean(value={LoggingRegistryCenterAdminDiscovery.class})
@ConditionalOnProperty(prefix="api.boot.logging", name={"admin.server-address"})
public class ApiBootLoggingAdminAppointAutoConfiguration {
    private ApiBootLoggingProperties apiBootLoggingProperties;

    public ApiBootLoggingAdminAppointAutoConfiguration(ApiBootLoggingProperties apiBootLoggingProperties) {
        this.apiBootLoggingProperties = apiBootLoggingProperties;
    }

    @Bean
    @ConditionalOnMissingBean
    public LoggingAdminDiscovery loggingConfigAdminDiscovery() {
        String[] serverAddressArray = this.apiBootLoggingProperties.getAdmin().getServerAddress().split(",");
        LoggingAppointAdminDiscovery appointAdminDiscovery = new LoggingAppointAdminDiscovery(serverAddressArray);
        LoadBalanceStrategy loadBalanceStrategy = this.instantiationLoadBalanceStrategy();
        appointAdminDiscovery.setLoadBalanceStrategy(loadBalanceStrategy);
        return appointAdminDiscovery;
    }

    private LoadBalanceStrategy instantiationLoadBalanceStrategy() {
        SmoothWeightedRoundRobinStrategy strategy;
        LoadBalanceStrategyAway strategyAway = this.apiBootLoggingProperties.getLoadBalanceStrategy();
        switch (strategyAway) {
            case POLL_WEIGHT: {
                strategy = new SmoothWeightedRoundRobinStrategy();
                break;
            }
            default: {
                strategy = new RandomWeightedStrategy();
            }
        }
        return strategy;
    }
}

