/*
 * Decompiled with CFR 0.152.
 */
package org.minbox.framework.api.boot.autoconfigure.logging;

import java.util.stream.Collectors;
import org.minbox.framework.api.boot.autoconfigure.logging.ApiBootLoggingAdminAppointAutoConfiguration;
import org.minbox.framework.api.boot.autoconfigure.logging.ApiBootLoggingAdminDiscoveryAutoConfiguration;
import org.minbox.framework.api.boot.autoconfigure.logging.ApiBootLoggingGlobalLogStorageAutoConfiguration;
import org.minbox.framework.api.boot.autoconfigure.logging.ApiBootLoggingOpenfeignAutoConfiguration;
import org.minbox.framework.api.boot.autoconfigure.logging.ApiBootLoggingProperties;
import org.minbox.framework.api.boot.autoconfigure.logging.ApiBootLoggingRestTemplateAutoConfiguration;
import org.minbox.framework.api.boot.autoconfigure.logging.ApiBootLoggingWebAutoConfiguration;
import org.minbox.framework.api.boot.autoconfigure.logging.LoggingFactoryBeanCustomizer;
import org.minbox.framework.api.boot.autoconfigure.logging.LoggingFactoryBeanCustomizers;
import org.minbox.framework.logging.client.LoggingFactoryBean;
import org.minbox.framework.logging.client.admin.discovery.LoggingAdminDiscovery;
import org.minbox.framework.logging.client.admin.report.LoggingReportScheduled;
import org.minbox.framework.logging.spring.context.annotation.client.EnableLoggingClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.boot.autoconfigure.web.servlet.WebMvcAutoConfiguration;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.scheduling.annotation.EnableAsync;

@Configuration
@ConditionalOnClass(value={LoggingFactoryBean.class, EnableLoggingClient.class})
@EnableConfigurationProperties(value={ApiBootLoggingProperties.class})
@AutoConfigureAfter(value={WebMvcAutoConfiguration.class})
@ConditionalOnWebApplication
@EnableAsync
@Import(value={ApiBootLoggingAdminDiscoveryAutoConfiguration.class, ApiBootLoggingAdminAppointAutoConfiguration.class, ApiBootLoggingOpenfeignAutoConfiguration.class, ApiBootLoggingRestTemplateAutoConfiguration.class, ApiBootLoggingWebAutoConfiguration.class, ApiBootLoggingGlobalLogStorageAutoConfiguration.class})
@EnableLoggingClient
public class ApiBootLoggingAutoConfiguration {
    static Logger logger = LoggerFactory.getLogger(ApiBootLoggingAutoConfiguration.class);
    private ApiBootLoggingProperties apiBootLoggingProperties;

    public ApiBootLoggingAutoConfiguration(ApiBootLoggingProperties apiBootLoggingProperties) {
        this.apiBootLoggingProperties = apiBootLoggingProperties;
    }

    @Bean
    @ConditionalOnMissingBean
    public LoggingFactoryBeanCustomizers loggingFactoryBeanCustomizers(ObjectProvider<LoggingFactoryBeanCustomizer> customizers) {
        return new LoggingFactoryBeanCustomizers(customizers.orderedStream().collect(Collectors.toList()));
    }

    @Bean
    @ConditionalOnMissingBean
    public LoggingFactoryBean loggingFactoryBean(ObjectProvider<LoggingAdminDiscovery> loggingAdminDiscoveryObjectProvider, LoggingFactoryBeanCustomizers customizers) {
        LoggingFactoryBean factoryBean = new LoggingFactoryBean();
        factoryBean.setIgnorePaths(this.apiBootLoggingProperties.getIgnorePaths());
        factoryBean.setIgnoreHttpStatus(this.apiBootLoggingProperties.getIgnoreHttpStatus());
        factoryBean.setReportAway(this.apiBootLoggingProperties.getReportAway());
        factoryBean.setNumberOfRequestLog(Integer.valueOf(this.apiBootLoggingProperties.getReportNumberOfRequestLog()));
        factoryBean.setReportInitialDelaySecond(this.apiBootLoggingProperties.getReportInitialDelaySecond());
        factoryBean.setReportIntervalSecond(this.apiBootLoggingProperties.getReportIntervalSecond());
        factoryBean.setLoggingAdminDiscovery((LoggingAdminDiscovery)loggingAdminDiscoveryObjectProvider.getIfAvailable());
        factoryBean.setShowConsoleLog(this.apiBootLoggingProperties.isShowConsoleLog());
        factoryBean.setFormatConsoleLog(this.apiBootLoggingProperties.isFormatConsoleLogJson());
        logger.info("\u3010LoggingFactoryBean\u3011init successfully.");
        return customizers.customize(factoryBean);
    }

    @Bean
    @ConditionalOnProperty(prefix="api.boot.logging", name={"report-away"}, havingValue="timing")
    @ConditionalOnMissingBean
    public LoggingReportScheduled loggingReportScheduled(LoggingFactoryBean factoryBean) {
        return new LoggingReportScheduled(factoryBean);
    }
}

