/*
 * Decompiled with CFR 0.152.
 */
package org.minbox.framework.api.boot.autoconfigure.logging;

import java.util.Arrays;
import java.util.List;
import org.minbox.framework.logging.client.http.rest.LoggingRestTemplateInterceptor;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.context.annotation.Configuration;
import org.springframework.util.ObjectUtils;
import org.springframework.web.client.RestTemplate;

@Configuration
@ConditionalOnClass(value={RestTemplate.class})
@ConditionalOnBean(value={RestTemplate.class})
public class ApiBootLoggingRestTemplateAutoConfiguration {
    public ApiBootLoggingRestTemplateAutoConfiguration(RestTemplate restTemplate) {
        List interceptors = restTemplate.getInterceptors();
        LoggingRestTemplateInterceptor interceptor = new LoggingRestTemplateInterceptor();
        if (ObjectUtils.isEmpty((Object)interceptors)) {
            restTemplate.setInterceptors(Arrays.asList(interceptor));
        } else {
            interceptors.add(interceptor);
        }
    }
}

