/*
 * Decompiled with CFR 0.152.
 */
package org.minbox.framework.api.boot.autoconfigure.logging;

import org.minbox.framework.api.boot.autoconfigure.logging.ApiBootLoggingAutoConfiguration;
import org.minbox.framework.api.boot.autoconfigure.logging.ApiBootLoggingProperties;
import org.minbox.framework.logging.client.LoggingFactoryBean;
import org.minbox.framework.logging.client.interceptor.web.LoggingWebInterceptor;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.config.annotation.InterceptorRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;

@Configuration
@ConditionalOnClass(value={LoggingFactoryBean.class})
@ConditionalOnWebApplication(type=ConditionalOnWebApplication.Type.SERVLET)
@EnableConfigurationProperties(value={ApiBootLoggingProperties.class})
@AutoConfigureAfter(value={ApiBootLoggingAutoConfiguration.class})
public class ApiBootLoggingWebAutoConfiguration
implements WebMvcConfigurer {
    private LoggingWebInterceptor loggingWebInterceptor;
    private ApiBootLoggingProperties loggingProperties;

    public ApiBootLoggingWebAutoConfiguration(LoggingWebInterceptor loggingWebInterceptor, ApiBootLoggingProperties loggingProperties) {
        this.loggingWebInterceptor = loggingWebInterceptor;
        this.loggingProperties = loggingProperties;
    }

    public void addInterceptors(InterceptorRegistry registry) {
        registry.addInterceptor((HandlerInterceptor)this.loggingWebInterceptor).addPathPatterns(this.loggingProperties.getLoggingPathPrefix());
    }
}

