/*
 * Decompiled with CFR 0.152.
 */
package org.minbox.framework.api.boot.autoconfigure.logging.admin;

import org.minbox.framework.api.boot.autoconfigure.logging.admin.ApiBootLoggingAdminDataBaseAutoConfiguration;
import org.minbox.framework.api.boot.autoconfigure.logging.admin.ApiBootLoggingAdminMongoAutoConfiguration;
import org.minbox.framework.api.boot.autoconfigure.logging.admin.ApiBootLoggingAdminProperties;
import org.minbox.framework.api.boot.autoconfigure.logging.admin.ui.ApiBootLoggingAdminUiAutoConfiguration;
import org.minbox.framework.logging.admin.LoggingAdminFactoryBean;
import org.minbox.framework.logging.admin.storage.LoggingStorage;
import org.minbox.framework.logging.spring.context.annotation.admin.EnableLoggingAdmin;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.scheduling.annotation.EnableAsync;

@Configuration
@ConditionalOnClass(value={LoggingAdminFactoryBean.class})
@EnableConfigurationProperties(value={ApiBootLoggingAdminProperties.class})
@Import(value={ApiBootLoggingAdminUiAutoConfiguration.class})
@EnableAsync
@EnableLoggingAdmin
@AutoConfigureAfter(value={ApiBootLoggingAdminDataBaseAutoConfiguration.class, ApiBootLoggingAdminMongoAutoConfiguration.class})
public class ApiBootLoggingAdminAutoConfiguration {
    static Logger logger = LoggerFactory.getLogger(ApiBootLoggingAdminAutoConfiguration.class);
    private ApiBootLoggingAdminProperties apiBootLoggingAdminProperties;

    public ApiBootLoggingAdminAutoConfiguration(ApiBootLoggingAdminProperties apiBootLoggingAdminProperties) {
        this.apiBootLoggingAdminProperties = apiBootLoggingAdminProperties;
    }

    @Bean
    @ConditionalOnMissingBean
    public LoggingAdminFactoryBean loggingAdminFactoryBean(LoggingStorage loggingStorage) {
        LoggingAdminFactoryBean factoryBean = new LoggingAdminFactoryBean();
        factoryBean.setLoggingStorage(loggingStorage);
        factoryBean.setShowConsoleReportLog(this.apiBootLoggingAdminProperties.isShowConsoleReportLog());
        factoryBean.setFormatConsoleLogJson(this.apiBootLoggingAdminProperties.isFormatConsoleLogJson());
        logger.info("\u3010LoggingAdminFactoryBean\u3011init successfully.");
        return factoryBean;
    }
}

