/*
 * Decompiled with CFR 0.152.
 */
package org.minbox.framework.api.boot.autoconfigure.logging.admin;

import javax.sql.DataSource;
import org.minbox.framework.logging.admin.LoggingAdminFactoryBean;
import org.minbox.framework.logging.admin.storage.LoggingDataSourceStorage;
import org.minbox.framework.logging.admin.storage.LoggingStorage;
import org.springframework.beans.factory.BeanCreationException;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.jdbc.DataSourceAutoConfiguration;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConditionalOnClass(value={DataSource.class, LoggingAdminFactoryBean.class})
@ConditionalOnBean(value={DataSource.class})
@ConditionalOnProperty(prefix="api.boot.logging.admin", name={"storage-away"}, havingValue="jdbc")
@AutoConfigureAfter(value={DataSourceAutoConfiguration.class})
public class ApiBootLoggingAdminDataBaseAutoConfiguration {
    @Bean
    @ConditionalOnMissingBean(value={LoggingStorage.class})
    public LoggingStorage loggingDataSourceStorage(DataSource dataSource) {
        return new LoggingDataSourceStorage(dataSource);
    }

    @Configuration
    @ConditionalOnMissingBean(value={DataSource.class})
    public static class DataSourceNotFoundConfiguration
    implements InitializingBean {
        public void afterPropertiesSet() throws Exception {
            throw new BeanCreationException("No " + DataSource.class.getName() + " Found.");
        }
    }
}

