/*
 * Decompiled with CFR 0.152.
 */
package org.minbox.framework.api.boot.autoconfigure.logging.admin.ui;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.List;
import org.minbox.framework.api.boot.autoconfigure.logging.admin.ApiBootLoggingAdminAutoConfiguration;
import org.minbox.framework.api.boot.autoconfigure.logging.admin.ui.ApiBootLoggingAdminUiProperties;
import org.minbox.framework.logging.admin.LoggingAdminFactoryBean;
import org.minbox.framework.logging.admin.ui.HomepageForwardingFilter;
import org.minbox.framework.logging.admin.ui.LoggingAdminUiEndpoint;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.servlet.config.annotation.ResourceHandlerRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;
import org.thymeleaf.spring5.templateresolver.SpringResourceTemplateResolver;
import org.thymeleaf.templatemode.TemplateMode;

@Configuration
@ConditionalOnClass(value={LoggingAdminUiEndpoint.class})
@EnableConfigurationProperties(value={ApiBootLoggingAdminUiProperties.class})
@AutoConfigureAfter(value={ApiBootLoggingAdminAutoConfiguration.class})
@ConditionalOnWebApplication(type=ConditionalOnWebApplication.Type.SERVLET)
public class ApiBootLoggingAdminUiAutoConfiguration
implements WebMvcConfigurer,
InitializingBean,
ApplicationContextAware {
    static Logger logger = LoggerFactory.getLogger(ApiBootLoggingAdminUiAutoConfiguration.class);
    private static final String RESOURCE_PREFIX = "/**";
    private static final String TEMPLATE_SUFFIX = ".html";
    private static final List<String> DEFAULT_UI_ROUTES = Arrays.asList("/about/**", "/services/**", "/logs/**", "/wallboard/**");
    private ApplicationContext applicationContext;
    private ApiBootLoggingAdminUiProperties adminUiProperties;
    private LoggingAdminFactoryBean loggingAdminFactoryBean;

    public ApiBootLoggingAdminUiAutoConfiguration(ApiBootLoggingAdminUiProperties adminUiProperties, LoggingAdminFactoryBean loggingAdminFactoryBean) {
        this.adminUiProperties = adminUiProperties;
        this.loggingAdminFactoryBean = loggingAdminFactoryBean;
    }

    public void addResourceHandlers(ResourceHandlerRegistry registry) {
        registry.addResourceHandler(new String[]{RESOURCE_PREFIX}).addResourceLocations(this.adminUiProperties.getResourceLocations());
    }

    @Bean
    public SpringResourceTemplateResolver adminTemplateResolver() {
        SpringResourceTemplateResolver resolver = new SpringResourceTemplateResolver();
        resolver.setApplicationContext(this.applicationContext);
        resolver.setPrefix(this.adminUiProperties.getTemplateLocation());
        resolver.setSuffix(TEMPLATE_SUFFIX);
        resolver.setTemplateMode(TemplateMode.HTML);
        resolver.setCharacterEncoding(StandardCharsets.UTF_8.name());
        resolver.setCacheable(this.adminUiProperties.isCacheTemplates());
        resolver.setOrder(Integer.valueOf(10));
        resolver.setCheckExistence(true);
        return resolver;
    }

    @Bean
    @ConditionalOnMissingBean
    public HomepageForwardingFilter homepageForwardFilter() throws IOException {
        return new HomepageForwardingFilter("/", DEFAULT_UI_ROUTES);
    }

    public void afterPropertiesSet() throws Exception {
        this.loggingAdminFactoryBean.getAdminUiSetting().setBrand(this.adminUiProperties.getBrand());
        this.loggingAdminFactoryBean.getAdminUiSetting().setTitle(this.adminUiProperties.getTitle());
        this.loggingAdminFactoryBean.getAdminUiSetting().setRoutes(DEFAULT_UI_ROUTES);
        logger.info("LoggingAdmin UiSetting set successfully.");
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
        logger.debug("ApplicationContext set successfully.");
    }
}

