/*
 * Decompiled with CFR 0.152.
 */
package org.minbox.framework.api.boot.autoconfigure.message.pipe.server;

import java.util.List;
import java.util.stream.Collectors;
import org.minbox.framework.api.boot.autoconfigure.message.pipe.server.MessagePipeConfigurationCustomizer;
import org.minbox.framework.api.boot.autoconfigure.message.pipe.server.MessagePipeConfigurationCustomizers;
import org.minbox.framework.api.boot.autoconfigure.message.pipe.server.MessagePipeServerProperties;
import org.minbox.framework.api.boot.autoconfigure.message.pipe.server.ServerConfigurationCustomizer;
import org.minbox.framework.api.boot.autoconfigure.message.pipe.server.ServerConfigurationCustomizers;
import org.minbox.framework.message.pipe.server.config.MessagePipeConfiguration;
import org.minbox.framework.message.pipe.server.config.ServerConfiguration;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.data.redis.connection.RedisConnectionFactory;
import org.springframework.data.redis.listener.RedisMessageListenerContainer;

@ConditionalOnClass(value={ServerConfiguration.class, RedisMessageListenerContainer.class})
@EnableConfigurationProperties(value={MessagePipeServerProperties.class})
public class MessagePipeServerAutoConfiguration {
    private MessagePipeServerProperties messagePipeServerProperties;

    public MessagePipeServerAutoConfiguration(MessagePipeServerProperties messagePipeServerProperties) {
        this.messagePipeServerProperties = messagePipeServerProperties;
    }

    @Bean
    @ConditionalOnMissingBean
    public ServerConfigurationCustomizers serverConfigurationCustomizers(ObjectProvider<ServerConfigurationCustomizer> customizers) {
        List<ServerConfigurationCustomizer> sortedCustomizers = customizers.orderedStream().collect(Collectors.toList());
        return new ServerConfigurationCustomizers(sortedCustomizers);
    }

    @Bean
    public ServerConfiguration serverConfiguration(ServerConfigurationCustomizers customizers) {
        ServerConfiguration configuration = this.messagePipeServerProperties.getConfiguration();
        return customizers.customizer(configuration);
    }

    @Bean
    @ConditionalOnMissingBean
    public RedisMessageListenerContainer redisMessageListenerContainer(RedisConnectionFactory redisConnectionFactory) {
        RedisMessageListenerContainer container = new RedisMessageListenerContainer();
        container.setConnectionFactory(redisConnectionFactory);
        return container;
    }

    @Bean
    @ConditionalOnMissingBean
    public MessagePipeConfigurationCustomizers messagePipeConfigurationCustomizers(ObjectProvider<MessagePipeConfigurationCustomizer> customizers) {
        List<MessagePipeConfigurationCustomizer> sortedCustomizers = customizers.orderedStream().collect(Collectors.toList());
        return new MessagePipeConfigurationCustomizers(sortedCustomizers);
    }

    @Bean
    public MessagePipeConfiguration messagePipeConfiguration(MessagePipeConfigurationCustomizers customizers) {
        MessagePipeConfiguration configuration = MessagePipeConfiguration.defaultConfiguration();
        return customizers.customizer(configuration);
    }

    @Bean
    public MessagePipeConfigurationCustomizer customizerLockTime() {
        return configuration -> {
            MessagePipeConfiguration.LockTime lockTime = new MessagePipeConfiguration.LockTime().setLeaseTime(this.messagePipeServerProperties.getLockLeaseTime()).setTimeUnit(this.messagePipeServerProperties.getLockLeaseTimeUnit());
            configuration.setLockTime(lockTime);
        };
    }

    @Bean
    public MessagePipeConfigurationCustomizer customizerMonitorTime() {
        return configuration -> configuration.setMessagePipeMonitorMillis(this.messagePipeServerProperties.getMessagePipeMonitorMillis());
    }
}

