/*
 * Decompiled with CFR 0.152.
 */
package org.minbox.framework.api.boot.autoconfigure.mongo;

import java.util.Optional;
import java.util.concurrent.TimeUnit;
import org.minbox.framework.api.boot.autoconfigure.mongo.ApiBootMongoClientSettingsProperties;
import org.minbox.framework.mongo.client.setting.MongoClientSettingsBean;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.mongo.MongoAutoConfiguration;
import org.springframework.boot.autoconfigure.mongo.MongoClientSettingsBuilderCustomizer;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.annotation.Order;

@Configuration
@EnableConfigurationProperties(value={ApiBootMongoClientSettingsProperties.class})
@ConditionalOnClass(value={MongoClientSettingsBean.class})
@AutoConfigureBefore(value={MongoAutoConfiguration.class})
public class ApiBootMongoClientSettingsAutoConfiguration {
    private MongoClientSettingsBean clientSettingsBean;

    public ApiBootMongoClientSettingsAutoConfiguration(ApiBootMongoClientSettingsProperties properties) {
        this.clientSettingsBean = Optional.ofNullable(properties.getSettings()).orElse(new MongoClientSettingsBean());
    }

    @Bean
    @Order(value=0)
    public MongoClientSettingsBuilderCustomizer apiBootMongoSocketSettings() {
        return clientSettingsBuilder -> Optional.ofNullable(this.clientSettingsBean.getSocket()).ifPresent(socketSettings -> clientSettingsBuilder.applyToSocketSettings(socket -> socket.readTimeout(Long.valueOf(socketSettings.getReadTimeoutMilliSeconds()).intValue(), TimeUnit.MILLISECONDS).connectTimeout(Long.valueOf(socketSettings.getConnectTimeoutMilliSeconds()).intValue(), TimeUnit.MILLISECONDS).receiveBufferSize(socketSettings.getReceiveBufferSize()).sendBufferSize(socketSettings.getSendBufferSize())));
    }

    @Bean
    @Order(value=1)
    public MongoClientSettingsBuilderCustomizer apiBootMongoHeartbeatSocketSettings() {
        return clientSettingsBuilder -> Optional.ofNullable(this.clientSettingsBean.getHeartbeatSocket()).ifPresent(heartbeatSocketSettings -> clientSettingsBuilder.applyToSocketSettings(heartBeatSocket -> heartBeatSocket.readTimeout(Long.valueOf(heartbeatSocketSettings.getReadTimeoutMilliSeconds()).intValue(), TimeUnit.MILLISECONDS).connectTimeout(Long.valueOf(heartbeatSocketSettings.getConnectTimeoutMilliSeconds()).intValue(), TimeUnit.MILLISECONDS).receiveBufferSize(heartbeatSocketSettings.getReceiveBufferSize()).sendBufferSize(heartbeatSocketSettings.getSendBufferSize())));
    }

    @Bean
    @Order(value=2)
    public MongoClientSettingsBuilderCustomizer apiBootMongoClusterSettings() {
        return clientSettingsBuilder -> Optional.ofNullable(this.clientSettingsBean.getCluster()).ifPresent(clusterSettings -> clientSettingsBuilder.applyToClusterSettings(cluster -> {
            Optional.ofNullable(clusterSettings.getMode()).ifPresent(mode -> cluster.mode(mode));
            Optional.ofNullable(clusterSettings.getRequiredClusterType()).ifPresent(requiredClusterType -> cluster.requiredClusterType(requiredClusterType));
            Optional.ofNullable(clusterSettings.getRequiredReplicaSetName()).ifPresent(requiredReplicaSetName -> cluster.requiredReplicaSetName(requiredReplicaSetName));
            cluster.localThreshold(clusterSettings.getLocalThresholdMilliSeconds(), TimeUnit.MILLISECONDS).serverSelectionTimeout(clusterSettings.getServerSelectionTimeoutMilliSeconds(), TimeUnit.MILLISECONDS);
        }));
    }

    @Bean
    @Order(value=3)
    public MongoClientSettingsBuilderCustomizer apiBootMongoServerSettings() {
        return clientSettingsBuilder -> Optional.ofNullable(this.clientSettingsBean.getServer()).ifPresent(serverSettings -> clientSettingsBuilder.applyToServerSettings(server -> server.heartbeatFrequency(serverSettings.getHeartbeatFrequencyMilliSeconds(), TimeUnit.MILLISECONDS).minHeartbeatFrequency(serverSettings.getMinHeartbeatFrequencyMilliSeconds(), TimeUnit.MILLISECONDS)));
    }

    @Bean
    @Order(value=4)
    public MongoClientSettingsBuilderCustomizer apiBootMongoConnectionPoolSettings() {
        return clientSettingsBuilder -> Optional.ofNullable(this.clientSettingsBean.getConnectionPool()).ifPresent(connectionPoolSettings -> clientSettingsBuilder.applyToConnectionPoolSettings(pool -> pool.maxSize(connectionPoolSettings.getMaxSize()).minSize(connectionPoolSettings.getMinSize()).maxWaitTime(connectionPoolSettings.getMaxWaitTimeMilliSeconds(), TimeUnit.MILLISECONDS).maxConnectionLifeTime(connectionPoolSettings.getMaxConnectionLifeTimeMilliSeconds(), TimeUnit.MILLISECONDS).maxConnectionIdleTime(connectionPoolSettings.getMaxConnectionIdleTimeMilliSeconds(), TimeUnit.MILLISECONDS).maintenanceFrequency(connectionPoolSettings.getMaintenanceFrequencyMilliSeconds(), TimeUnit.MILLISECONDS).maintenanceInitialDelay(connectionPoolSettings.getMaintenanceInitialDelayMilliSeconds(), TimeUnit.MILLISECONDS)));
    }

    @Bean
    @Order(value=5)
    public MongoClientSettingsBuilderCustomizer apiBootMongoSslSettings() {
        return clientSettingsBuilder -> Optional.ofNullable(this.clientSettingsBean.getSsl()).ifPresent(sslSettings -> clientSettingsBuilder.applyToSslSettings(ssl -> ssl.enabled(sslSettings.isEnabled()).invalidHostNameAllowed(sslSettings.isInvalidHostNameAllowed())));
    }
}

