/*
 * Decompiled with CFR 0.152.
 */
package org.minbox.framework.api.boot.autoconfigure.oauth;

import java.util.List;
import org.minbox.framework.api.boot.autoconfigure.oauth.ApiBootAuthorizationServerAutoConfiguration;
import org.minbox.framework.api.boot.autoconfigure.oauth.ApiBootOauthProperties;
import org.minbox.framework.oauth.AuthorizationServerConfiguration;
import org.minbox.framework.oauth.grant.OAuth2TokenGranter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.security.oauth2.config.annotation.builders.InMemoryClientDetailsServiceBuilder;
import org.springframework.security.oauth2.config.annotation.configurers.ClientDetailsServiceConfigurer;
import org.springframework.security.oauth2.config.annotation.web.configuration.EnableAuthorizationServer;
import org.springframework.security.oauth2.provider.token.TokenStore;
import org.springframework.security.oauth2.provider.token.store.InMemoryTokenStore;

@Configuration
@ConditionalOnClass(value={AuthorizationServerConfiguration.class})
@EnableConfigurationProperties(value={ApiBootOauthProperties.class})
@EnableAuthorizationServer
@ConditionalOnProperty(prefix="api.boot.oauth", name={"away"}, havingValue="memory", matchIfMissing=true)
public class ApiBootAuthorizationMemoryServerAutoConfiguration
extends ApiBootAuthorizationServerAutoConfiguration {
    static Logger logger = LoggerFactory.getLogger(ApiBootAuthorizationMemoryServerAutoConfiguration.class);

    public ApiBootAuthorizationMemoryServerAutoConfiguration(ObjectProvider<List<OAuth2TokenGranter>> objectProvider, ApiBootOauthProperties apiBootOauthProperties) {
        super(objectProvider, apiBootOauthProperties);
        logger.info("ApiBoot Oauth2 initialize using memory.");
    }

    public void configure(ClientDetailsServiceConfigurer clients) throws Exception {
        InMemoryClientDetailsServiceBuilder inMemoryClientDetailsServiceBuilder = clients.inMemory();
        this.apiBootOauthProperties.getClients().stream().forEach(client -> inMemoryClientDetailsServiceBuilder.withClient(client.getClientId()).secret(this.passwordEncoder().encode((CharSequence)client.getClientSecret())).authorizedGrantTypes(client.getGrantTypes()).scopes(client.getScopes()).resourceIds(client.getResourceId()).accessTokenValiditySeconds(client.getAccessTokenValiditySeconds()).refreshTokenValiditySeconds(client.getRefreshTokenValiditySeconds()));
    }

    @Bean
    public TokenStore memoryTokenStore() {
        return new InMemoryTokenStore();
    }
}

