/*
 * Decompiled with CFR 0.152.
 */
package org.minbox.framework.api.boot.autoconfigure.oauth;

import java.util.List;
import org.minbox.framework.api.boot.autoconfigure.oauth.ApiBootOauthProperties;
import org.minbox.framework.oauth.AuthorizationServerConfiguration;
import org.minbox.framework.oauth.OAuthConfigProperties;
import org.minbox.framework.oauth.grant.OAuth2TokenGranter;
import org.minbox.framework.oauth.response.AuthorizationDeniedResponse;
import org.minbox.framework.oauth.response.DefaultAuthorizationDeniedResponse;
import org.minbox.framework.oauth.translator.DefaultWebResponseExceptionTranslator;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.security.oauth2.provider.error.WebResponseExceptionTranslator;
import org.springframework.security.oauth2.provider.token.AccessTokenConverter;
import org.springframework.security.oauth2.provider.token.DefaultAccessTokenConverter;
import org.springframework.security.oauth2.provider.token.store.JwtAccessTokenConverter;

public class ApiBootAuthorizationServerAutoConfiguration
extends AuthorizationServerConfiguration {
    protected ApiBootOauthProperties apiBootOauthProperties;

    public ApiBootAuthorizationServerAutoConfiguration(ObjectProvider<List<OAuth2TokenGranter>> objectProvider, ApiBootOauthProperties apiBootOauthProperties) {
        super(objectProvider);
        this.apiBootOauthProperties = apiBootOauthProperties;
    }

    @Bean
    @ConditionalOnMissingBean
    public OAuthConfigProperties oAuthConfigProperties() {
        OAuthConfigProperties properties = new OAuthConfigProperties();
        properties.setAlwaysCreateToken(this.apiBootOauthProperties.isAlwaysCreateToken());
        return properties;
    }

    @Bean
    @ConditionalOnProperty(prefix="api.boot.oauth", name={"jwt.enable"}, havingValue="true")
    public AccessTokenConverter jwtAccessTokenConverter() {
        JwtAccessTokenConverter converter = new JwtAccessTokenConverter();
        converter.setSigningKey(this.apiBootOauthProperties.getJwt().getSignKey());
        return converter;
    }

    @Bean
    @ConditionalOnProperty(prefix="api.boot.oauth", name={"jwt.enable"}, havingValue="false", matchIfMissing=true)
    public AccessTokenConverter defaultAccessTokenConverter() {
        return new DefaultAccessTokenConverter();
    }

    @Bean
    @ConditionalOnMissingBean
    public AuthorizationDeniedResponse authorizationDeniedResponse() {
        return new DefaultAuthorizationDeniedResponse();
    }

    @Bean
    @ConditionalOnBean(value={AuthorizationDeniedResponse.class})
    @ConditionalOnMissingBean
    public WebResponseExceptionTranslator webResponseExceptionTranslator(AuthorizationDeniedResponse authorizationDeniedResponse) {
        return new DefaultWebResponseExceptionTranslator(authorizationDeniedResponse);
    }
}

