/*
 * Decompiled with CFR 0.152.
 */
package org.minbox.framework.api.boot.autoconfigure.oauth;

import java.util.List;
import javax.sql.DataSource;
import org.minbox.framework.api.boot.autoconfigure.oauth.ApiBootAuthorizationServerAutoConfiguration;
import org.minbox.framework.api.boot.autoconfigure.oauth.ApiBootOauthProperties;
import org.minbox.framework.api.boot.autoconfigure.oauth.OAuthClientStorageAway;
import org.minbox.framework.api.boot.common.exception.ApiBootException;
import org.minbox.framework.oauth.AuthorizationServerConfiguration;
import org.minbox.framework.oauth.grant.OAuth2TokenGranter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.data.redis.RedisAutoConfiguration;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.redis.connection.RedisConnectionFactory;
import org.springframework.security.oauth2.config.annotation.builders.InMemoryClientDetailsServiceBuilder;
import org.springframework.security.oauth2.config.annotation.configurers.ClientDetailsServiceConfigurer;
import org.springframework.security.oauth2.config.annotation.web.configuration.EnableAuthorizationServer;
import org.springframework.security.oauth2.provider.token.TokenStore;
import org.springframework.security.oauth2.provider.token.store.redis.RedisTokenStore;

@Configuration
@EnableConfigurationProperties(value={ApiBootOauthProperties.class})
@EnableAuthorizationServer
@ConditionalOnBean(value={RedisConnectionFactory.class})
@ConditionalOnClass(value={AuthorizationServerConfiguration.class})
@ConditionalOnProperty(prefix="api.boot.oauth", name={"away"}, havingValue="redis")
@AutoConfigureAfter(value={RedisAutoConfiguration.class})
public class ApiBootAuthorizationServerRedisAutoConfiguration
extends ApiBootAuthorizationServerAutoConfiguration {
    static Logger logger = LoggerFactory.getLogger(ApiBootAuthorizationServerRedisAutoConfiguration.class);
    private RedisConnectionFactory redisConnectionFactory;
    private DataSource dataSource;

    public ApiBootAuthorizationServerRedisAutoConfiguration(ObjectProvider<List<OAuth2TokenGranter>> objectProvider, ApiBootOauthProperties apiBootOauthProperties, ObjectProvider<RedisConnectionFactory> connectionFactoryProvider, ObjectProvider<DataSource> dataSourceProvider) {
        super(objectProvider, apiBootOauthProperties);
        this.redisConnectionFactory = (RedisConnectionFactory)connectionFactoryProvider.getIfAvailable();
        this.dataSource = (DataSource)dataSourceProvider.getIfAvailable();
        logger.info("ApiBoot Oauth2 initialize using redis.");
    }

    public void configure(ClientDetailsServiceConfigurer clients) throws Exception {
        if (OAuthClientStorageAway.jdbc == this.apiBootOauthProperties.getClientStorageAway() && this.dataSource == null) {
            throw new ApiBootException("If you use jdbc to store the client, please instantiate the datasource.");
        }
        switch (this.apiBootOauthProperties.getClientStorageAway()) {
            case memory: {
                InMemoryClientDetailsServiceBuilder inMemoryClientDetailsServiceBuilder = clients.inMemory();
                this.apiBootOauthProperties.getClients().stream().forEach(client -> inMemoryClientDetailsServiceBuilder.withClient(client.getClientId()).secret(this.passwordEncoder().encode((CharSequence)client.getClientSecret())).authorizedGrantTypes(client.getGrantTypes()).scopes(client.getScopes()).resourceIds(client.getResourceId()).accessTokenValiditySeconds(client.getAccessTokenValiditySeconds()).refreshTokenValiditySeconds(client.getRefreshTokenValiditySeconds()));
                break;
            }
            case jdbc: {
                clients.jdbc(this.dataSource);
            }
        }
    }

    @Bean
    public TokenStore redisTokenStore() {
        return new RedisTokenStore(this.redisConnectionFactory);
    }
}

