/*
 * Decompiled with CFR 0.152.
 */
package org.minbox.framework.api.boot.autoconfigure.oss;

import com.aliyun.oss.OSSClient;
import org.minbox.framework.api.boot.autoconfigure.oss.ApiBootOssProperties;
import org.minbox.framework.oss.ObjectStorageProgress;
import org.minbox.framework.oss.ObjectStorageService;
import org.minbox.framework.oss.support.aliyun.AliyunObjectStorageService;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@EnableConfigurationProperties(value={ApiBootOssProperties.class})
@ConditionalOnClass(value={OSSClient.class})
@ConditionalOnProperty(prefix="api.boot.oss", name={"region", "access-key-id", "access-key-secret", "bucket-name"})
public class ApiBootOssAutoConfiguration {
    private ApiBootOssProperties apiBootOssProperties;
    private ObjectStorageProgress apiBootObjectStorageProgress;

    public ApiBootOssAutoConfiguration(ApiBootOssProperties apiBootOssProperties, ObjectProvider<ObjectStorageProgress> apiBootProgressProvider) {
        this.apiBootOssProperties = apiBootOssProperties;
        this.apiBootObjectStorageProgress = (ObjectStorageProgress)apiBootProgressProvider.getIfAvailable();
    }

    @Bean
    @ConditionalOnMissingBean
    ObjectStorageService apiBootOssService() {
        AliyunObjectStorageService objectStorageService = new AliyunObjectStorageService(this.apiBootOssProperties.getRegion().getEndpoint(), this.apiBootOssProperties.getBucketName(), this.apiBootOssProperties.getAccessKeyId(), this.apiBootOssProperties.getAccessKeySecret(), this.apiBootOssProperties.getDomain());
        objectStorageService.setObjectStorageProgress(this.apiBootObjectStorageProgress);
        return objectStorageService;
    }
}

