/*
 * Decompiled with CFR 0.152.
 */
package org.minbox.framework.api.boot.autoconfigure.pageable;

import java.util.List;
import java.util.Properties;
import javax.annotation.PostConstruct;
import org.apache.ibatis.plugin.Interceptor;
import org.apache.ibatis.session.SqlSessionFactory;
import org.minbox.framework.api.boot.autoconfigure.pageable.ApiBootMyBatisPageableProperties;
import org.minbox.framework.mybatis.pageable.common.configure.PageableConfigurer;
import org.minbox.framework.mybatis.pageable.interceptor.MyBatisExecutePageableInterceptor;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.jdbc.DataSourceAutoConfiguration;
import org.springframework.boot.context.properties.EnableConfigurationProperties;

@ConditionalOnBean(value={SqlSessionFactory.class})
@EnableConfigurationProperties(value={ApiBootMyBatisPageableProperties.class})
@ConditionalOnClass(value={MyBatisExecutePageableInterceptor.class})
@AutoConfigureAfter(value={DataSourceAutoConfiguration.class})
public class ApiBootMybatisPageableAutoConfiguration {
    private ApiBootMyBatisPageableProperties pageableProperties;
    private List<SqlSessionFactory> sqlSessionFactoryList;
    private PageableConfigurer pageableConfigurer;

    public ApiBootMybatisPageableAutoConfiguration(ApiBootMyBatisPageableProperties myBatisPageableProperties, ObjectProvider<List<SqlSessionFactory>> interceptorsProvider, ObjectProvider<PageableConfigurer> pageableConfigurerObjectProvider) {
        this.pageableProperties = myBatisPageableProperties;
        this.sqlSessionFactoryList = (List)interceptorsProvider.getIfAvailable();
        this.pageableConfigurer = (PageableConfigurer)pageableConfigurerObjectProvider.getIfAvailable();
    }

    @PostConstruct
    void addInterceptors() {
        MyBatisExecutePageableInterceptor interceptor = new MyBatisExecutePageableInterceptor();
        Properties properties = this.pageableProperties.convertProperties();
        interceptor.setProperties(properties);
        for (SqlSessionFactory sqlSessionFactory : this.sqlSessionFactoryList) {
            this.addPreInterceptors(sqlSessionFactory);
            sqlSessionFactory.getConfiguration().addInterceptor((Interceptor)interceptor);
            this.addPostInterceptors(sqlSessionFactory);
        }
    }

    void addPreInterceptors(SqlSessionFactory sqlSessionFactory) {
        if (this.allowPageableConfigurer() && this.pageableConfigurer.getPrePlugins() != null) {
            this.loopAddInterceptor(this.pageableConfigurer.getPrePlugins(), sqlSessionFactory);
        }
    }

    void addPostInterceptors(SqlSessionFactory sqlSessionFactory) {
        if (this.allowPageableConfigurer() && this.pageableConfigurer.getPostPlugins() != null) {
            this.loopAddInterceptor(this.pageableConfigurer.getPostPlugins(), sqlSessionFactory);
        }
    }

    void loopAddInterceptor(List<Interceptor> interceptors, SqlSessionFactory sqlSessionFactory) {
        for (Interceptor interceptor : interceptors) {
            sqlSessionFactory.getConfiguration().addInterceptor(interceptor);
        }
    }

    boolean allowPageableConfigurer() {
        return this.pageableConfigurer != null;
    }
}

