/*
 * Decompiled with CFR 0.152.
 */
package org.minbox.framework.api.boot.autoconfigure.push;

import cn.jpush.api.JPushClient;
import java.util.HashMap;
import java.util.Map;
import org.minbox.framework.api.boot.autoconfigure.push.ApiBootMessagePushProperties;
import org.minbox.framework.api.boot.push.ApiBootMessagePushService;
import org.minbox.framework.api.boot.push.aop.advistor.ApiBootMessagePushClientSwitchAdvisor;
import org.minbox.framework.api.boot.push.aop.interceptor.ApiBootMessagePushSwitchAnnotationInterceptor;
import org.minbox.framework.api.boot.push.model.PushClientConfig;
import org.minbox.framework.api.boot.push.support.ApiBootMessagePushJiGuangServiceImpl;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.util.ObjectUtils;

@Configuration
@ConditionalOnClass(value={ApiBootMessagePushService.class, JPushClient.class})
@EnableConfigurationProperties(value={ApiBootMessagePushProperties.class})
public class ApiBootMessagePushAutoConfiguration {
    private ApiBootMessagePushProperties apiBootMessagePushProperties;
    private static final String DEFAULT_CLIENT_NAME = "default";

    public ApiBootMessagePushAutoConfiguration(ApiBootMessagePushProperties apiBootMessagePushProperties) {
        this.apiBootMessagePushProperties = apiBootMessagePushProperties;
    }

    @Bean
    @ConditionalOnMissingBean
    ApiBootMessagePushService apiBootMessagePushService() {
        Map<String, PushClientConfig> configs = this.getClientConfig();
        return new ApiBootMessagePushJiGuangServiceImpl(configs, this.apiBootMessagePushProperties.isProduction());
    }

    @Bean
    @ConditionalOnMissingBean
    ApiBootMessagePushSwitchAnnotationInterceptor apiBootMessagePushSwitchAnnotationInterceptor() {
        return new ApiBootMessagePushSwitchAnnotationInterceptor();
    }

    @Bean
    @ConditionalOnMissingBean
    ApiBootMessagePushClientSwitchAdvisor apiBootMessagePushClientSwitchAdvisor() {
        return new ApiBootMessagePushClientSwitchAdvisor(this.apiBootMessagePushSwitchAnnotationInterceptor());
    }

    private Map<String, PushClientConfig> getClientConfig() {
        HashMap<String, PushClientConfig> configs = new HashMap<String, PushClientConfig>(1);
        configs.put(DEFAULT_CLIENT_NAME, this.apiBootMessagePushProperties.getClient());
        if (!ObjectUtils.isEmpty(this.apiBootMessagePushProperties.getMultiple())) {
            configs.putAll(this.apiBootMessagePushProperties.getMultiple());
        }
        return configs;
    }
}

