/*
 * Decompiled with CFR 0.152.
 */
package org.minbox.framework.api.boot.autoconfigure.quartz;

import java.time.Duration;
import java.util.HashMap;
import java.util.Map;
import org.minbox.framework.api.boot.autoconfigure.quartz.PropKey;
import org.springframework.boot.autoconfigure.quartz.JobStoreType;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.jdbc.DataSourceInitializationMode;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConfigurationProperties(prefix="api.boot.quartz")
public class ApiBootQuartzProperties {
    public static final String API_BOOT_QUARTZ_PREFIX = "api.boot.quartz";
    private JobStoreType jobStoreType = JobStoreType.MEMORY;
    private String schedulerName;
    private boolean autoStartup = true;
    private Duration startupDelay = Duration.ofSeconds(0L);
    private boolean waitForJobsToCompleteOnShutdown = false;
    private boolean overwriteExistingJobs = false;
    private final Map<String, String> properties = new HashMap<String, String>();
    private final Prop prop = new Prop();
    private final Jdbc jdbc = new Jdbc();

    public JobStoreType getJobStoreType() {
        return this.jobStoreType;
    }

    public String getSchedulerName() {
        return this.schedulerName;
    }

    public boolean isAutoStartup() {
        return this.autoStartup;
    }

    public Duration getStartupDelay() {
        return this.startupDelay;
    }

    public boolean isWaitForJobsToCompleteOnShutdown() {
        return this.waitForJobsToCompleteOnShutdown;
    }

    public boolean isOverwriteExistingJobs() {
        return this.overwriteExistingJobs;
    }

    public Map<String, String> getProperties() {
        return this.properties;
    }

    public Prop getProp() {
        return this.prop;
    }

    public Jdbc getJdbc() {
        return this.jdbc;
    }

    public void setJobStoreType(JobStoreType jobStoreType) {
        this.jobStoreType = jobStoreType;
    }

    public void setSchedulerName(String schedulerName) {
        this.schedulerName = schedulerName;
    }

    public void setAutoStartup(boolean autoStartup) {
        this.autoStartup = autoStartup;
    }

    public void setStartupDelay(Duration startupDelay) {
        this.startupDelay = startupDelay;
    }

    public void setWaitForJobsToCompleteOnShutdown(boolean waitForJobsToCompleteOnShutdown) {
        this.waitForJobsToCompleteOnShutdown = waitForJobsToCompleteOnShutdown;
    }

    public void setOverwriteExistingJobs(boolean overwriteExistingJobs) {
        this.overwriteExistingJobs = overwriteExistingJobs;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ApiBootQuartzProperties)) {
            return false;
        }
        ApiBootQuartzProperties other = (ApiBootQuartzProperties)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isAutoStartup() != other.isAutoStartup()) {
            return false;
        }
        if (this.isWaitForJobsToCompleteOnShutdown() != other.isWaitForJobsToCompleteOnShutdown()) {
            return false;
        }
        if (this.isOverwriteExistingJobs() != other.isOverwriteExistingJobs()) {
            return false;
        }
        JobStoreType this$jobStoreType = this.getJobStoreType();
        JobStoreType other$jobStoreType = other.getJobStoreType();
        if (this$jobStoreType == null ? other$jobStoreType != null : !this$jobStoreType.equals(other$jobStoreType)) {
            return false;
        }
        String this$schedulerName = this.getSchedulerName();
        String other$schedulerName = other.getSchedulerName();
        if (this$schedulerName == null ? other$schedulerName != null : !this$schedulerName.equals(other$schedulerName)) {
            return false;
        }
        Duration this$startupDelay = this.getStartupDelay();
        Duration other$startupDelay = other.getStartupDelay();
        if (this$startupDelay == null ? other$startupDelay != null : !((Object)this$startupDelay).equals(other$startupDelay)) {
            return false;
        }
        Map<String, String> this$properties = this.getProperties();
        Map<String, String> other$properties = other.getProperties();
        if (this$properties == null ? other$properties != null : !((Object)this$properties).equals(other$properties)) {
            return false;
        }
        Prop this$prop = this.getProp();
        Prop other$prop = other.getProp();
        if (this$prop == null ? other$prop != null : !this$prop.equals(other$prop)) {
            return false;
        }
        Jdbc this$jdbc = this.getJdbc();
        Jdbc other$jdbc = other.getJdbc();
        return !(this$jdbc == null ? other$jdbc != null : !this$jdbc.equals(other$jdbc));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ApiBootQuartzProperties;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isAutoStartup() ? 79 : 97);
        result = result * 59 + (this.isWaitForJobsToCompleteOnShutdown() ? 79 : 97);
        result = result * 59 + (this.isOverwriteExistingJobs() ? 79 : 97);
        JobStoreType $jobStoreType = this.getJobStoreType();
        result = result * 59 + ($jobStoreType == null ? 43 : $jobStoreType.hashCode());
        String $schedulerName = this.getSchedulerName();
        result = result * 59 + ($schedulerName == null ? 43 : $schedulerName.hashCode());
        Duration $startupDelay = this.getStartupDelay();
        result = result * 59 + ($startupDelay == null ? 43 : ((Object)$startupDelay).hashCode());
        Map<String, String> $properties = this.getProperties();
        result = result * 59 + ($properties == null ? 43 : ((Object)$properties).hashCode());
        Prop $prop = this.getProp();
        result = result * 59 + ($prop == null ? 43 : $prop.hashCode());
        Jdbc $jdbc = this.getJdbc();
        result = result * 59 + ($jdbc == null ? 43 : $jdbc.hashCode());
        return result;
    }

    public String toString() {
        return "ApiBootQuartzProperties(jobStoreType=" + this.getJobStoreType() + ", schedulerName=" + this.getSchedulerName() + ", autoStartup=" + this.isAutoStartup() + ", startupDelay=" + this.getStartupDelay() + ", waitForJobsToCompleteOnShutdown=" + this.isWaitForJobsToCompleteOnShutdown() + ", overwriteExistingJobs=" + this.isOverwriteExistingJobs() + ", properties=" + this.getProperties() + ", prop=" + this.getProp() + ", jdbc=" + this.getJdbc() + ")";
    }

    public static class Jdbc {
        private static final String DEFAULT_SCHEMA_LOCATION = "classpath:org/quartz/impl/jdbcjobstore/tables_@@platform@@.sql";
        private String schema = "classpath:org/quartz/impl/jdbcjobstore/tables_@@platform@@.sql";
        private DataSourceInitializationMode initializeSchema = DataSourceInitializationMode.EMBEDDED;
        private String commentPrefix = "--";

        public String getSchema() {
            return this.schema;
        }

        public void setSchema(String schema) {
            this.schema = schema;
        }

        public DataSourceInitializationMode getInitializeSchema() {
            return this.initializeSchema;
        }

        public void setInitializeSchema(DataSourceInitializationMode initializeSchema) {
            this.initializeSchema = initializeSchema;
        }

        public String getCommentPrefix() {
            return this.commentPrefix;
        }

        public void setCommentPrefix(String commentPrefix) {
            this.commentPrefix = commentPrefix;
        }
    }

    public static class Prop {
        @PropKey(value="org.quartz.scheduler.instanceName")
        private String schedulerInstanceName = "jobScheduler";
        @PropKey(value="org.quartz.scheduler.instanceId")
        private String schedulerInstanceId = "AUTO";
        @PropKey(value="org.quartz.jobStore.class")
        private String jobStoreClass = "org.quartz.impl.jdbcjobstore.JobStoreTX";
        @PropKey(value="org.quartz.jobStore.driverDelegateClass")
        private String jobStoreDriverDelegateClass = "org.quartz.impl.jdbcjobstore.StdJDBCDelegate";
        @PropKey(value="org.quartz.jobStore.tablePrefix")
        private String jobStoreTablePrefix = "QRTZ_";
        @PropKey(value="org.quartz.jobStore.isClustered")
        private boolean jobStoreClustered = true;
        @PropKey(value="org.quartz.jobStore.clusterCheckinInterval")
        private long jobStoreClusterCheckinInterval = 20000L;
        @PropKey(value="org.quartz.threadPool.threadsInheritContextClassLoaderOfInitializingThread")
        private boolean threadPoolThreadsInheritContextClassLoaderOfInitializingThread = true;

        public String getSchedulerInstanceName() {
            return this.schedulerInstanceName;
        }

        public String getSchedulerInstanceId() {
            return this.schedulerInstanceId;
        }

        public String getJobStoreClass() {
            return this.jobStoreClass;
        }

        public String getJobStoreDriverDelegateClass() {
            return this.jobStoreDriverDelegateClass;
        }

        public String getJobStoreTablePrefix() {
            return this.jobStoreTablePrefix;
        }

        public boolean isJobStoreClustered() {
            return this.jobStoreClustered;
        }

        public long getJobStoreClusterCheckinInterval() {
            return this.jobStoreClusterCheckinInterval;
        }

        public boolean isThreadPoolThreadsInheritContextClassLoaderOfInitializingThread() {
            return this.threadPoolThreadsInheritContextClassLoaderOfInitializingThread;
        }

        public void setSchedulerInstanceName(String schedulerInstanceName) {
            this.schedulerInstanceName = schedulerInstanceName;
        }

        public void setSchedulerInstanceId(String schedulerInstanceId) {
            this.schedulerInstanceId = schedulerInstanceId;
        }

        public void setJobStoreClass(String jobStoreClass) {
            this.jobStoreClass = jobStoreClass;
        }

        public void setJobStoreDriverDelegateClass(String jobStoreDriverDelegateClass) {
            this.jobStoreDriverDelegateClass = jobStoreDriverDelegateClass;
        }

        public void setJobStoreTablePrefix(String jobStoreTablePrefix) {
            this.jobStoreTablePrefix = jobStoreTablePrefix;
        }

        public void setJobStoreClustered(boolean jobStoreClustered) {
            this.jobStoreClustered = jobStoreClustered;
        }

        public void setJobStoreClusterCheckinInterval(long jobStoreClusterCheckinInterval) {
            this.jobStoreClusterCheckinInterval = jobStoreClusterCheckinInterval;
        }

        public void setThreadPoolThreadsInheritContextClassLoaderOfInitializingThread(boolean threadPoolThreadsInheritContextClassLoaderOfInitializingThread) {
            this.threadPoolThreadsInheritContextClassLoaderOfInitializingThread = threadPoolThreadsInheritContextClassLoaderOfInitializingThread;
        }
    }
}

